<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Struk Kunjungan</title>
    <style>
        body {
            font-family: monospace, Arial, sans-serif;
            font-size: 11px;
            background: #fff;
        }
        .struk {
            width: 56mm;
            margin: 0 auto;
            padding: 0;
        }
        .center { text-align: center; }
        .bold { font-weight: bold; }
        .line { border-top: 1px dashed #333; margin: 4px 0; }
        .info {
            display: flex;
            justify-content: space-between;
        }
        .info label { min-width: 50px; }
        .right { text-align: right; }
        #backBtn { display: none; width: 100%; margin: 10px 0; }
        @media  print {
            html, body {
                width: 58mm !important;
                min-width: 58mm !important;
                max-width: 58mm !important;
                margin: 1mm !important;
                padding: 0 !important;
                background: #fff !important;
                box-sizing: border-box;
            }
            .struk {
                width: 56mm !important;
                min-width: 56mm !important;
                max-width: 56mm !important;
                margin: 0 auto !important;
                padding: 0 !important;
            }
            .center { text-align: center !important; }
            .bold { font-weight: bold !important; }
            .line { border-top: 1px dashed #333 !important; margin: 4px 0 !important; }
            .info {
                display: flex !important;
                justify-content: space-between !important;
            }
            .info label { min-width: 50px !important; }
            #backBtn { display: none !important; }
        }
    </style>
</head>
<body>
    <div class="struk">
        <br>
        <br>
        <div class="center bold" style="margin-bottom:2px;">
           <!--BOOSTER FITNESS CENTER-->
           <img src="<?php echo e(asset('images/logobw.png')); ?>" style="width: 180px; height: 40px;" class="fill-current"> 
        </div>
        <div class="center" style="margin-bottom:2px;">
            Jl. Grompol-Jambangan,Bekon,RT01<br>
            RW01,karangmalang,masaran<br>
            0852-0068-2000
        </div>
        <div class="line"></div>
        <div class="info">
            <span>Tanggal</span>
            <span><?php echo e(\Carbon\Carbon::parse($attendance->tanggal)->format('d/m/Y')); ?></span>
        </div>
        <div class="info">
            <span>Jam</span>
            <span><?php echo e($attendance->jam_masuk); ?></span>
        </div>
        <div class="info">
            <span>Nama</span>
            <span><?php echo e($attendance->visitor->nama); ?></span>
        </div>
        <div class="info">
            <span>Kontak</span>
            <span><?php echo e($attendance->visitor->kontak); ?></span>
        </div>
        <div class="line"></div>
        <div class="center bold" style="margin-bottom:2px;">LATIHAN MANDIRI</div>
        <div class="info">
            <span>Harga</span>
            <span>Rp <?php echo e(number_format($attendance->harga, 0, ',', '.')); ?></span>
        </div>
        <div class="info">
            <span>Bayar</span>
            <span>Rp <?php echo e(number_format($attendance->bayar, 0, ',', '.')); ?></span>
        </div>
        <div class="info">
            <span>Kembalian</span>
            <span>Rp <?php echo e(number_format($attendance->kembalian, 0, ',', '.')); ?></span>
        </div>
        <div class="info">
            <span>Metode</span>
            <span><?php echo e(strtoupper($attendance->payment_method)); ?></span>
        </div>
        <div class="line"></div>
        <div class="center" style="margin-top:5px;margin-bottom:8px;">
            Terima kasih
        </div>
        <br>.
        <br>.
        <!--<button id="backBtn">Kembali</button>-->
    </div>
<script>
    window.onload = function() {
        window.print();
    }
</script>
</body>
</html><?php /**PATH /home/linm9634/public_html/kasir-gym.linkerapp.my.id/resources/views/visitor/struk_mandiri.blade.php ENDPATH**/ ?>