<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Struk Pembelian</title>
    <style>
    body {
        font-family: monospace, Arial, sans-serif;
        font-size: 12px;
        background: #fff;
        color: #000; /* Pastikan warna teks utama hitam */
        font-weight: bold; /* Jadikan semua teks di body tebal secara default */
    }
    .struk {
        width: 56mm;
        margin: 0 auto;
        padding: 0;
    }
    .text-center, .center {
        text-align: center;
        font-weight: bold; /* Pastikan teks di tengah juga tebal */
    }
    .bold {
        font-weight: bold;
    }
    .line {
        border-top: 1px dashed #000;
        margin: 5px 0;
    }
    .right {
        text-align: right;
    }
    table {
        width: 100%;
        border-collapse: collapse;
    }
    td {
        vertical-align: top;
        padding: 0;
        margin: 0;
        color: #000; /* Pastikan teks di dalam tabel hitam */
        font-weight: bold; /* Jadikan teks di dalam tabel tebal */
    }
    #backBtn { display: none; width: 100%; margin: 10px 0; }
    @media  print {
        html, body {
            width: 58mm !important;
            min-width: 58mm !important;
            max-width: 58mm !important;
            margin: 1mm !important;
            padding: 0 !important;
            background: #fff !important;
            box-sizing: border-box;
            color: #000 !important; /* Paksa teks hitam saat dicetak */
            font-weight: bold !important; /* Paksa teks tebal saat dicetak */
        }
        .struk {
            width: 56mm !important;
            min-width: 56mm !important;
            max-width: 56mm !important;
            margin: 0 auto !important;
            padding: 0 !important;
        }
        #backBtn { display: none !important; }
    }
</style>

</head>
<body>
    <div class="struk">
        <div class="text-center bold"> 
            <!--BOOSTER FITNESS CENTER-->
            <img src="<?php echo e(asset('images/logobw.png')); ?>" style="width: 180px; height: 40px;" class="fill-current"> 
        </div>
        <div class="text-center">
            Jl. Grompol-Jambangan,Bekon,RT01<br>
            RW01,karangmalang,masaran<br>
          </div>
        <div class="text-center">WA: 08123456789</div>
        <div class="line"></div>
        <div>
            Tgl: <?php echo e(\Carbon\Carbon::parse($purchase->tanggal)->format('d-m-Y H:i:s')); ?><br>
            Pembeli: <?php echo e($purchase->member->nama ?? $purchase->nama_pembeli ?? '-'); ?><br>
            Payment: <?php echo e($purchase->payment_method); ?>

        </div>
        <div class="line"></div>
        <table>
        <?php $__currentLoopData = $purchase->details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td colspan="2"><?php echo e($d->product->nama ?? 'Produk ID:'.$d->product_id); ?></td>
            </tr>
            <tr>
                <td><?php echo e($d->qty); ?> x <?php echo e(number_format($d->harga_satuan,0,',','.')); ?></td>
                <td class="right"><?php echo e(number_format($d->qty * $d->harga_satuan,0,',','.')); ?></td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </table>
        <div class="line"></div>
        <table>
            <tr>
                <td>Total</td>
                <td class="right"><?php echo e(number_format($purchase->total_harga,0,',','.')); ?></td>
            </tr>
            <tr>
                <td>Bayar</td>
                <td class="right"><?php echo e(number_format($purchase->bayar,0,',','.')); ?></td>
            </tr>
            <tr>
                <td>Kembali</td>
                <td class="right"><?php echo e(number_format($purchase->kembali,0,',','.')); ?></td>
            </tr>
        </table>
        <div class="line"></div>
        <div class="text-center">
            --- Terima Kasih ---
        </div>
        <br>.
        <br>.
        <!--<button id="backBtn">Kembali</button>-->
    </div>
<script>
    window.onload = function() {
        window.print();
    }
</script>
</body>
</html><?php /**PATH /home/linm9634/public_html/kasir-gym.linkerapp.my.id/resources/views/purchases/print.blade.php ENDPATH**/ ?>