<?php $__env->startSection('title', 'Rekap Absensi'); ?>

<?php $__env->startSection('content_header'); ?>
    <h1>Rekap Absensi Member</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="mb-3">
    <form method="GET" action="<?php echo e(url('/absensi/rekap')); ?>" class="form-inline">
        <div class="input-group mb-2 mr-sm-2">
            <input type="text" name="search" class="form-control" placeholder="Cari nama member" value="<?php echo e(request('search')); ?>">
        </div>
        <div class="input-group mb-2 mr-sm-2">
            <select name="filter" class="form-control">
                <!--<option value="">-- Semua Data --</option>-->
                <option value="harian" <?php echo e(request('filter') == 'harian' ? 'selected' : ''); ?>>Harian</option>
                <option value="mingguan" <?php echo e(request('filter') == 'mingguan' ? 'selected' : ''); ?>>Mingguan</option>
                <option value="bulanan" <?php echo e(request('filter') == 'bulanan' ? 'selected' : ''); ?>>Bulanan</option>
                <option value="tahunan" <?php echo e(request('filter') == 'tahunan' ? 'selected' : ''); ?>>Tahunan</option>
            </select>
        </div>
        <button type="submit" class="btn btn-primary mb-2">Terapkan</button>
        <?php if(request('filter') || request('search')): ?>
            <a href="<?php echo e(url('/absensi/rekap')); ?>" class="btn btn-default mb-2 ml-2">Reset</a>
        <?php endif; ?>
    </form>
</div>
<div class="table-responsive">
    <table class="table table-bordered table-striped mt-3">
        <thead>
            <tr>
                <th>#</th>
                <th>Tanggal & Jam Scan</th>
                <th>Nama Member</th>
                <!-- <th>ID Member</th>
                <th>Keterangan</th> -->
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $absensi; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $absen): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><?php echo e($absensi->firstItem() + $i); ?></td>
                    <td><?php echo e(\Carbon\Carbon::parse($absen->waktu_scan)->format('d-m-Y H:i:s')); ?></td>
                    <td><?php echo e($absen->member ? $absen->member->nama : '-'); ?></td>
                    <!-- <td><?php echo e($absen->member_id); ?></td>
                    <td><?php echo e($absen->keterangan ?? '-'); ?></td> -->
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="5" class="text-center">Belum ada data absensi.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>
<div>
    <?php echo e($absensi->links()); ?>

</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/gym/gym-membership/resources/views/absensi/rekap.blade.php ENDPATH**/ ?>