

<?php $__env->startSection('title', 'Daftar Member'); ?>

<?php $__env->startSection('content_header'); ?>
    <h1>Daftar Member</h1>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css"/>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
<script>
    $(document).ready(function() {
      $('.table').DataTable({
        "ordering": true,
        "order": [],
        "paging": false, // kalau sudah pakai paginasi laravel, matikan ini
        "info": false,
        "searching": false // sudah ada form cari manual
      });
    });
</script>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<?php if(session('success')): ?>
    <div class="alert alert-success"><?php echo e(session('success')); ?></div>
<?php endif; ?>
<div class="d-flex justify-content-between align-items-center mb-3">
    <a href="<?php echo e(route('members.create')); ?>" class="btn btn-success btn-sm">
        <i class="fas fa-plus"></i> Tambah Member
    </a>
    <form method="GET" action="<?php echo e(route('members.index')); ?>" class="d-flex" style="max-width:190px;">
        <div class="input-group input-group-sm">
            <input type="text" name="q" value="<?php echo e($search ?? ''); ?>" class="form-control" placeholder="Cari...">
            <button class="btn btn-primary btn-sm" type="submit">
                <i class="fas fa-search"></i>
            </button>
        </div>
    </form>
</div>
<table class="table table-sm table-bordered table-hover">
    <thead>
        <tr>
            <th>No.</th> 
            <th>Nama</th>
            <th>Kontak</th>
            <th>Alamat</th>
            <th>Expired</th>
            <th>Status</th>
            <th style="width:200px;">Aksi</th>
            <th style="width:80px;">Hapus</th>
        </tr>
    </thead>
    <tbody>
        <?php $__currentLoopData = $members; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td><?php echo e($loop->iteration); ?></td> 
            <td><?php echo e($member->nama); ?></td>
            <td><?php echo e($member->kontak); ?></td>
            <td><?php echo e($member->alamat); ?></td>
            <td><?php echo e($member->expired_at); ?></td>
            
            <td>
                <?php if($member->is_active && $member->expired_at && \Carbon\Carbon::parse($member->expired_at)->isFuture()): ?>
                   <span class="badge bg-success">Aktif</span>
                <?php else: ?>
                    <span class="badge bg-danger">Nonaktif</span>
                <?php endif; ?>
            </td>
            <td>
                <a href="<?php echo e(route('members.card', $member->id)); ?>" target="_blank" class="btn btn-info btn-xs">Cetak</a>
                <a href="<?php echo e(route('members.show', $member->id)); ?>" class="btn btn-info btn-xs">Detail</a>
                <a href="<?php echo e(route('members.edit', $member->id)); ?>" class="btn btn-warning btn-xs">Edit</a>
            </td>
            <td> <?php if(auth()->user()->role == 'admin'): ?>
            <form action="<?php echo e(route('members.destroy', $member->id)); ?>" method="POST" style="display:inline;">
                    <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="btn btn-danger btn-xs"
                        onclick="return confirm('Yakin hapus?')">Hapus</button>
                </form>
                <?php endif; ?>
            </td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
<div>
    <?php echo e($members->links()); ?>

</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/linm9634/public_html/kasir-gym.linkerapp.my.id/resources/views/members/index.blade.php ENDPATH**/ ?>