<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Struk PT</title>
    <style>
        body {
            font-family: monospace, Arial, sans-serif;
            font-size: 11px;
            background: #fff;
        }
        .struk {
            width: 56mm;
            margin: 0 auto;
            padding: 0;
        }
        .center { text-align: center; }
        .bold { font-weight: bold; }
        .line { border-top: 1px dashed #333; margin: 4px 0; }
        .info {
            display: flex;
            justify-content: space-between;
        }
        .info label { min-width: 50px; }
        .right { text-align: right; }
        #backBtn { display: none; width: 100%; margin: 10px 0; }
        @media  print {
            html, body {
                width: 58mm !important;
                min-width: 58mm !important;
                max-width: 58mm !important;
                margin: 1mm !important;
                padding: 0 !important;
                background: #fff !important;
                box-sizing: border-box;
            }
            .struk {
                width: 56mm !important;
                min-width: 56mm !important;
                max-width: 56mm !important;
                margin: 0 auto !important;
                padding: 0 !important;
            }
            .center { text-align: center !important; }
            .bold { font-weight: bold !important; }
            .line { border-top: 1px dashed #333 !important; margin: 4px 0 !important; }
            .info {
                display: flex !important;
                justify-content: space-between !important;
            }
            .info label { min-width: 50px !important; }
            #backBtn { display: none !important; }
        }
    </style>
</head>
<body>
<div class="struk">
    <div class="center">
        <br>
        <br>
        <div class="center bold" style="margin-bottom:2px;">
            <!--BOOSTER FITNESS CENTER-->
            <img src="<?php echo e(asset('images/logobw.png')); ?>" style="width: 180px; height: 40px;" class="fill-current"> 
        </div>
        <div class="center" style="margin-bottom:2px;">
            Jl. Grompol-Jambangan,Bekon,RT01<br>
            RW01,karangmalang,masaran<br>
            0852-0068-2000
        </div>
    </div>
    <hr>
    <div class="info"><span>Tanggal</span><span><?php echo e(\Carbon\Carbon::parse($pt->tanggal ?? now())->format('d/m/Y')); ?></span></div>
    <div class="info"><span>Pembeli</span><span class="right"><?php echo e($visitor->nama ?? '-'); ?></span></div>
    <div class="info"><span>Paket</span><span class="right"><?php echo e($pt->produk_nama ?? '-'); ?></span></div>
    <div class="info"><span>Instruktur</span><span class="right"><?php echo e($pt->instruktur_nama ?? '-'); ?></span></div>
    <hr>
    <div class="info"><span>Harga</span><span class="right">Rp<?php echo e(number_format($pt->harga ?? 0,0,',','.')); ?></span></div>
    <?php if(isset($pt->bayar) && isset($pt->kembalian)): ?>
    <div class="info"><span>Bayar</span><span class="right">Rp<?php echo e(number_format($pt->bayar ?? 0,0,',','.')); ?></span></div>
    <div class="info"><span>Kembalian</span><span class="right">Rp<?php echo e(number_format($pt->kembalian ?? 0,0,',','.')); ?></span></div>
    <?php endif; ?>
    <div class="info"><span>Metode</span><span class="right"><?php echo e($pt->payment_method ?? 'Cash'); ?></span></div>
    <hr>
    <div class="center small">
        Terima kasih!<br>
        <?php echo e(now()->format('d/m/Y H:i')); ?>

    </div>
    <!--<button id="backBtn">Kembali</button>-->
</div>
<script>
    window.onload = function() {
        window.print();
    }
</script>
</body>
</html><?php /**PATH /var/www/html/gym/gym-membership/resources/views/visitor/struk_pt.blade.php ENDPATH**/ ?>