

<?php $__env->startSection('title', 'Transaksi Produk'); ?>

<?php $__env->startSection('content_header'); ?>
    <h1>Transaksi Produk</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php if($errors->any()): ?>
    <div class="alert alert-danger">
        <ul>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
<?php endif; ?>

<form method="POST" action="<?php echo e(route('purchases.store')); ?>" id="form-transaksi">
    <?php echo csrf_field(); ?>

    <div class="form-group">
        <label>Pilih Pembeli</label>
        <div class="d-flex align-items-center mb-2">
            <button type="button" id="btn-scan-qr" class="btn btn-default btn-sm mr-2">Scan QR</button>
            <select id="buyer_type" name="buyer_type" class="form-control mr-2" style="width:120px;">
                <option value="member">Member</option>
                <option value="visitor">Visitor</option>
            </select>
            <input type="hidden" name="buyer_id" id="buyer_id">
        </div>
        <input type="text" id="buyer_search" class="form-control" placeholder="Cari nama pembeli..." autocomplete="off">
        <div id="buyer_suggestion" class="list-group mt-1"></div>
        <div id="buyer_detail" class="mt-2"></div>
        <div id="qr_area" class="mt-3" style="display:none;">
            <div id="reader" style="width:180px;"></div>
        </div>
    </div>

    <div class="form-group">
        <label>Kategori & Produk & Qty</label>
        <div id="produk-list">
            <div class="row mb-2 align-items-center">
                <div class="col-3">
                    <select name="kategori_id[]" class="form-control kategori-select" required>
                        <option value="">- kategori -</option>
                        <?php
                            $kategoriList = collect($products)->pluck('kategori')->unique()->sort()->values();
                        ?>
                        <?php $__currentLoopData = $kategoriList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kategori): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($kategori); ?>"><?php echo e(ucfirst(str_replace('_',' ',$kategori))); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col">
                    <select name="produk_id[]" class="form-control produk-select" required disabled>
                        <option value="">- pilih produk -</option>
                    </select>
                </div>
                <div class="col-2">
                    <input type="number" name="qty[]" class="form-control qty-input" min="1" value="1" required>
                </div>
                <div class="col-auto">
                    <button type="button" class="btn btn-success btn-tambah">+</button>
                </div>
            </div>
        </div>
    </div>

    <div class="form-group">
        <label>Metode Pembayaran</label>
        <select name="payment_method" class="form-control" id="payment_method" required>
            <option value="cash" selected>Cash</option>
            <option value="QRIS">QRIS</option>
        </select>
    </div>
    <div id="qris-image" class="text-center mb-3" style="display:none;">
        <img src="<?php echo e(asset('images/qris.png')); ?>" alt="QRIS" style="max-width:220px;">
    </div>
    <div class="form-group">
        <label>Total Belanja</label>
        <input type="text" class="form-control-plaintext" id="total-belanja" readonly value="Rp 0">
        <input type="hidden" name="total_harga" id="total_harga" value="0">
    </div>
    <div class="form-group">
        <label>Bayar</label>
        <input type="number" name="bayar" id="bayar" class="form-control" min="0" required autocomplete="off" placeholder="Masukkan nominal pembayaran">
    </div>
    <div class="form-group">
        <label>Kembali</label>
        <input type="text" id="kembali" class="form-control-plaintext" readonly value="Rp 0">
    </div>

    <button type="submit" class="btn btn-primary btn-block">Simpan Transaksi & Cetak Struk</button>
</form>

<?php $__env->startPush('js'); ?>
<script src="https://unpkg.com/html5-qrcode" type="text/javascript"></script>
<script>
    const members = <?php echo json_encode($members, 15, 512) ?>;
    const visitors = <?php echo json_encode($visitors, 15, 512) ?>;
    const allProducts = <?php echo json_encode($products, 15, 512) ?>;

    let html5QrcodeScanner; // Variabel global untuk mengontrol scanner

    function searchBuyer(type, keyword) {
        let data = type === 'visitor' ? visitors : members;
        return data.filter(item => item.nama.toLowerCase().includes(keyword.toLowerCase()));
    }

    function getProdukByKategori(kategori) {
        return allProducts.filter(p => p.kategori === kategori);
    }

    document.addEventListener('DOMContentLoaded', function() {
        const qrArea = document.getElementById('qr_area');
        const buyerType = document.getElementById('buyer_type');
        const buyerSearch = document.getElementById('buyer_search');
        const buyerSuggest = document.getElementById('buyer_suggestion');
        const buyerDetail = document.getElementById('buyer_detail');
        const buyerId = document.getElementById('buyer_id');
        const produkList = document.getElementById('produk-list');
        const paymentMethod = document.getElementById('payment_method');
        const bayarField = document.getElementById('bayar');
        const totalHargaField = document.getElementById('total_harga');
        const qrisImage = document.getElementById('qris-image');
        const kembaliField = document.getElementById('kembali');
        const totalBelanjaField = document.getElementById('total-belanja');

        // --- Opsi Scan QR ---
        document.getElementById('btn-scan-qr').onclick = function() {
            if (qrArea.style.display === 'none' || qrArea.style.display === '') {
                qrArea.style.display = 'block';
                if (!html5QrcodeScanner) {
                    html5QrcodeScanner = new Html5QrcodeScanner(
                        "reader", { fps: 10, qrbox: 200 }, false);
                    html5QrcodeScanner.render(onScanSuccess, onScanFailure);
                }
            } else {
                if (html5QrcodeScanner) {
                    html5QrcodeScanner.unmount().then(() => {
                        qrArea.style.display = 'none';
                        html5QrcodeScanner = null;
                    }).catch(err => {
                        console.error("Error unmounting scanner:", err);
                    });
                }
            }
        };

        function onScanSuccess(qrCodeMessage) {
            let type = buyerType.value;
            let found = (type === 'member' ? members : visitors).find(x => x.id == qrCodeMessage);
            if (found) {
                buyerId.value = found.id;
                buyerSearch.value = found.nama;
                buyerDetail.innerHTML = '<b>Nama:</b> ' + found.nama + '<br><b>Alamat:</b> ' + (found.alamat || '-') + '<br><b>Kontak:</b> ' + (found.kontak || '-');
                if (html5QrcodeScanner) {
                    html5QrcodeScanner.unmount().then(() => {
                        qrArea.style.display = 'none';
                        html5QrcodeScanner = null;
                    }).catch(err => {
                        console.error("Error unmounting scanner after success:", err);
                    });
                }
            } else {
                buyerDetail.innerHTML = '<span class="text-danger">Data tidak ditemukan</span>';
            }
        }

        function onScanFailure(errorMessage) {
            // Optional: log errors to the console
            // console.warn(`QR Code scanning error: ${errorMessage}`);
        }

        // --- Autocomplete Pembeli ---
        buyerSearch.addEventListener('input', function() {
            const keyword = this.value;
            const type = buyerType.value;
            if (keyword.length < 1) {
                buyerSuggest.innerHTML = '';
                return;
            }
            const hasil = searchBuyer(type, keyword);
            buyerSuggest.innerHTML = '';
            hasil.forEach(function(b) {
                const item = document.createElement('a');
                item.href = "#";
                item.className = "list-group-item list-group-item-action";
                item.textContent = b.nama + (b.alamat ? ' (' + b.alamat + ')' : '');
                item.onclick = function() {
                    buyerSearch.value = b.nama;
                    buyerId.value = b.id;
                    buyerDetail.innerHTML = '<b>Nama:</b> ' + b.nama + '<br><b>Alamat:</b> ' + (b.alamat || '-') + '<br><b>Kontak:</b> ' + (b.kontak || '-');
                    buyerSuggest.innerHTML = '';
                    return false;
                };
                buyerSuggest.appendChild(item);
            });
        });

        buyerType.addEventListener('change', function() {
            buyerSearch.value = '';
            buyerId.value = '';
            buyerDetail.innerHTML = '';
            buyerSuggest.innerHTML = '';
        });

        // --- Produk dinamis & total ---
        produkList.addEventListener('click', function(e) {
            if (e.target.classList.contains('btn-tambah')) {
                let row = e.target.closest('.row').cloneNode(true);
                let kategoriSelect = row.querySelector('.kategori-select');
                kategoriSelect.value = '';
                let produkSelect = row.querySelector('.produk-select');
                produkSelect.innerHTML = '<option value="">- pilih produk -</option>';
                produkSelect.disabled = true;
                row.querySelector('input.qty-input').value = 1;
                let btn = row.querySelector('button');
                btn.classList.remove('btn-success', 'btn-tambah');
                btn.classList.add('btn-danger', 'btn-hapus');
                btn.innerText = '-';
                produkList.appendChild(row);
            } else if (e.target.classList.contains('btn-hapus')) {
                if (document.querySelectorAll('#produk-list .row').length > 1) {
                    e.target.closest('.row').remove();
                }
            }
            updateTotal();
        });

        // Kategori -> Produk
        function handleKategoriChange(e) {
            const row = e.target.closest('.row');
            const kategori = e.target.value;
            const produkSelect = row.querySelector('.produk-select');
            produkSelect.innerHTML = '<option value="">- pilih produk -</option>';
            produkSelect.disabled = true;
            row.querySelector('input.qty-input').value = 1; // Reset qty
            if (kategori) {
                const prods = getProdukByKategori(kategori);
                prods.forEach(function(p) {
                    let opt = document.createElement('option');
                    opt.value = p.id;
                    opt.textContent = p.nama + ' (stok: ' + p.stok + ')';
                    opt.setAttribute('data-harga', p.harga);
                    produkSelect.appendChild(opt);
                });
                produkSelect.disabled = false;
            }
            updateTotal();
        }

        produkList.addEventListener('change', function(e) {
            if (e.target.classList.contains('kategori-select')) {
                handleKategoriChange(e);
            }
            if (e.target.classList.contains('produk-select') || e.target.classList.contains('qty-input')) {
                updateTotal();
            }
        });

        // Binding event listener untuk kategori-select awal
        document.querySelectorAll('.kategori-select').forEach(el => el.addEventListener('change', handleKategoriChange));

        // --- Metode pembayaran & Total ---
        paymentMethod.addEventListener('change', function() {
            if (this.value === 'QRIS') {
                bayarField.readOnly = true;
                bayarField.value = totalHargaField.value;
                qrisImage.style.display = '';
            } else {
                bayarField.readOnly = false;
                bayarField.value = '';
                qrisImage.style.display = 'none';
            }
            updateTotal();
        });

        function updateTotal() {
            let total = 0;
            document.querySelectorAll('#produk-list .row').forEach(function(row) {
                let select = row.querySelector('select.produk-select');
                let qty = parseInt(row.querySelector('input.qty-input').value) || 0;
                let harga = parseInt(select.selectedOptions[0]?.getAttribute('data-harga')) || 0;
                total += qty * harga;
            });

            totalBelanjaField.value = 'Rp ' + total.toLocaleString('id-ID');
            totalHargaField.value = total;

            if (paymentMethod.value === 'QRIS') {
                bayarField.value = total;
            }

            let bayar = parseInt(bayarField.value) || 0;
            let kembali = bayar - total;
            kembaliField.value = 'Rp ' + (kembali >= 0 ? kembali.toLocaleString('id-ID') : 0);
        }

        bayarField.addEventListener('input', updateTotal);
        setTimeout(updateTotal, 300);
    });
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/linm9634/public_html/kasir-gym.linkerapp.my.id/resources/views/purchases/create.blade.php ENDPATH**/ ?>