<?php $__env->startSection('title', 'Tambah Transaksi PT'); ?>
<?php $__env->startSection('content_header'); ?>
    <h1>Tambah Transaksi PT</h1>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<?php if($errors->any()): ?>
    <div class="alert alert-danger"><ul><?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <li><?php echo e($error); ?></li> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?></ul></div>
<?php endif; ?>

<form method="POST" action="<?php echo e(route('pt_purchases.store')); ?>">
    <?php echo csrf_field(); ?>

    <div class="form-group">
        <label>Pilih Pembeli</label>
        <select id="buyer_type" name="buyer_type" class="form-control" required>
            <option value="member">Member</option>
            <option value="visitor">Visitor</option>
        </select>
        <input type="text" id="buyer_search" class="form-control mt-2" placeholder="Cari nama..." autocomplete="off">
        <input type="hidden" name="buyer_id" id="buyer_id">
        <div id="buyer_suggestion" class="list-group mt-1"></div>
    </div>

    <div class="form-group">
        <label>Paket Latihan (Produk)</label>
        <select id="produk_id" name="produk_id" class="form-control" required>
            <option value="">- pilih produk -</option>
            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($p->id); ?>" data-harga="<?php echo e($p->harga); ?>"><?php echo e($p->nama); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>

    <div class="form-group">
        <label>Pilih Instruktur</label>
        <select name="instruktur_id" class="form-control" required>
            <option value="">- pilih instruktur -</option>
            <?php $__currentLoopData = $instrukturs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($pt->id); ?>"><?php echo e($pt->nama); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>
    <div class="form-group">
        <label>Tanggal Transaksi</label>
        <input type="date" name="tanggal" class="form-control" value="<?php echo e(date('Y-m-d')); ?>" required>
    </div>
    <div class="form-group">
        <label>Harga</label>
            <input type="text" name="harga_display" id="harga_display" class="form-control" readonly>
            <input type="hidden" name="harga" id="harga">
    </div>
    <div class="form-group">
        <label>Metode Pembayaran</label>
        <select name="payment_method" class="form-control" required>
            <option value="cash" selected>Cash</option>
            <option value="transfer">Transfer</option>
        </select>
    </div>
    <div class="form-group">
        <label>Pembayaran</label>
        <input type="number" name="bayar" id="bayar" class="form-control" min="0" required autocomplete="off" placeholder="Uang dibayar customer" required>
    </div>
    <div class="form-group">
        <label>Kembalian</label>
        <input type="text" id="kembalian_display" class="form-control" readonly>
        <input type="hidden" name="kembalian" id="kembalian">
    </div>
    <button type="submit" class="btn btn-primary btn-block">Simpan & Cetak Struk</button>
</form>

<?php $__env->startPush('js'); ?>
<script>
const members = <?php echo json_encode($members, 15, 512) ?>;
const visitors = <?php echo json_encode($visitors, 15, 512) ?>;

document.getElementById('buyer_search').addEventListener('input', function() {
    let type = document.getElementById('buyer_type').value;
    let keyword = this.value.toLowerCase();
    let data = type === 'member' ? members : visitors;
    let hasil = data.filter(item =>
        item.nama.toLowerCase().includes(keyword) ||
        (item.alamat && item.alamat.toLowerCase().includes(keyword))
    );
    let buyerSuggest = document.getElementById('buyer_suggestion');
    buyerSuggest.innerHTML = '';
    hasil.forEach(function(b) {
        let item = document.createElement('a');
        item.href = "#";
        item.className = "list-group-item list-group-item-action";
        item.innerHTML = `<b>${b.nama}</b> <span class="text-muted">(${b.alamat ?? '-'})</span>`;
        item.onclick = function() {
            document.getElementById('buyer_search').value = b.nama;
            document.getElementById('buyer_id').value = b.id;
            buyerSuggest.innerHTML = '';
            return false;
        };
        buyerSuggest.appendChild(item);
    });
});
document.getElementById('buyer_type').addEventListener('change', function() {
    document.getElementById('buyer_search').value = '';
    document.getElementById('buyer_id').value = '';
    document.getElementById('buyer_suggestion').innerHTML = '';
});

function formatRupiah(angka) {
    if(!angka) return '';
    return angka.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ".");
}

document.getElementById('produk_id').addEventListener('change', function() {
    let hargaRaw = this.selectedOptions[0].getAttribute('data-harga');
    let hargaInt = hargaRaw ? parseInt(hargaRaw) : '';
    document.getElementById('harga').value = hargaInt !== '' ? hargaInt : '';
    document.getElementById('harga_display').value = hargaInt !== '' ? formatRupiah(hargaInt) : '';
});

function hitungKembalian() {
    let bayar = parseInt(document.getElementById('bayar').value || "0");
    let harga = parseInt(document.getElementById('harga').value || "0");
    let kembalian = bayar - harga;
    document.getElementById('kembalian').value = kembalian > 0 ? kembalian : 0;
    document.getElementById('kembalian_display').value = kembalian > 0 ? formatRupiah(kembalian) : "0";
}

document.getElementById('bayar').addEventListener('input', hitungKembalian);
document.getElementById('produk_id').addEventListener('change', function() {
    // ... kode harga seperti sebelumnya ...
    let hargaRaw = this.selectedOptions[0].getAttribute('data-harga');
    let hargaInt = hargaRaw ? parseInt(hargaRaw) : '';
    document.getElementById('harga').value = hargaInt !== '' ? hargaInt : '';
    document.getElementById('harga_display').value = hargaInt !== '' ? formatRupiah(hargaInt) : '';
    hitungKembalian(); // update kembalian jika harga berubah
});

</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/gym/gym-membership/resources/views/pt_purchases/create.blade.php ENDPATH**/ ?>