<?php $__env->startSection('title', 'Rekap Kehadiran Visitor'); ?>

<?php $__env->startSection('content_header'); ?>
    <h1>Rekap Kehadiran Visitor</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="mb-3">
    <form class="form-inline" method="GET">
        <label class="mr-2">Tanggal</label>
        <input type="date" name="tanggal_awal" class="form-control form-control-sm mr-2" value="<?php echo e(request('tanggal_awal', $tanggal_awal)); ?>">
        <span class="mr-2">s/d</span>
        <input type="date" name="tanggal_akhir" class="form-control form-control-sm mr-2" value="<?php echo e(request('tanggal_akhir', $tanggal_akhir)); ?>">
        <button class="btn btn-info btn-sm">Tampilkan</button>
    </form>
</div>

<table class="table table-bordered table-hover">
    <thead>
        <tr>
            <th>Nama Visitor</th>
            <th>Kontak</th>
            <th>Alamat</th>
            <th>Jumlah Kunjungan</th>
            <th>Pendapatan</th>
            <th><?php if(auth()->user()->role == 'admin'): ?>
                Aksi
                <?php endif; ?>
            </th>
        </tr>
    </thead>
    <tbody>
        <?php $total_semua = 0; ?>
        <?php $__currentLoopData = $rekap; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php $total_semua += $v->total_pendapatan; ?>
        <tr>
            <td><?php echo e($v->nama); ?></td>
            <td><?php echo e($v->kontak); ?></td>
            <td><?php echo e($v->alamat); ?></td>
            <td><?php echo e($v->jumlah_kunjungan); ?></td>
            <td>Rp <?php echo e(number_format($v->total_pendapatan, 0, ',', '.')); ?></td>
            <td>
                <?php if(auth()->user()->role == 'admin'): ?>
                <form action="<?php echo e(route('visitor_attendance.destroy', $v->id)); ?>" method="POST" onsubmit="return confirm('Yakin hapus semua data kehadiran visitor ini?')">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button class="btn btn-danger btn-xs" type="submit">Hapus</button>
                </form>
                 <?php endif; ?>
            </td>            
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <th colspan="4" class="text-right">Total Pendapatan</th>
            <th>Rp <?php echo e(number_format($total_semua, 0, ',', '.')); ?></th>
        </tr>
    </tbody>
</table>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/linm9634/public_html/kasir-gym.linkerapp.my.id/resources/views/visitor_attendance/rekap.blade.php ENDPATH**/ ?>