<?php $__env->startSection('title', 'Detail Instruktur'); ?>
<?php $__env->startSection('content_header'); ?>
    <h1>Detail Instruktur: <?php echo e($instruktur->nama); ?></h1>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="mb-3">
    <a href="<?php echo e(route('instrukturs.index')); ?>" class="btn btn-secondary mb-2">Kembali ke Daftar</a>
    <a href="<?php echo e(route('instrukturs.edit', $instruktur->id)); ?>" class="btn btn-warning mb-2">Edit Instruktur</a>
</div>
<div class="card mb-3">
    <div class="card-header">Profil Instruktur</div>
    <div class="card-body">
        <p><b>Nama:</b> <?php echo e($instruktur->nama); ?></p>
        <p><b>Kontak:</b> <?php echo e($instruktur->kontak); ?></p>
        <p><b>Alamat:</b> <?php echo e($instruktur->alamat); ?></p>
    </div>
</div>
<div class="card">
    <div class="card-header">Riwayat Membimbing</div>
    <div class="card-body p-0">
        <table class="table table-striped m-0">
            <thead>
                <tr>
                    <th>Tanggal</th>
                    <th>Jenis</th>
                    <th>Nama Member/Visitor</th>
                    <th>Paket/Produk</th>
                    <th>Harga</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $riwayat; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trx): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><?php echo e($trx->tanggal); ?></td>
                    <td><?php echo e($trx->product->kategori == 'pt_sesi' ? 'PT Sesi' : 'PT Visit'); ?></td>
                    <td><?php echo e($trx->member ? $trx->member->nama : ($trx->visitor ? $trx->visitor->nama : '-')); ?></td>
                    <td><?php echo e($trx->product->nama); ?></td>
                    <td>Rp <?php echo e(number_format($trx->harga)); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="5" class="text-center">Belum ada riwayat membimbing.</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
        <div class="mt-3 px-3">
            <?php echo e($riwayat->links()); ?>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/gym/gym-membership/resources/views/instrukturs/show.blade.php ENDPATH**/ ?>