<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Gym Member Card</title>
    <style>
        body {
            background: #222;
            margin: 0;
            padding: 0;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            flex-direction: column; /* supaya tombol bisa di bawah card */
        }
        .card {
            width: 87mm;
            height: 54mm;
            border-radius: 0mm;
            border: 1px solid #f5f3f0;
            position: relative;
            overflow: hidden;
            font-family: 'Segoe UI', Arial, sans-serif;
            box-sizing: border-box;
            display: flex;
            flex-direction: column;
            justify-content: flex-start;
            align-items: center;
            padding-top: 7mm;
        }
        .card-bg {
            position: absolute;
            inset: 0;
            width: 100%;
            height: 100%;
            object-fit: cover;
            z-index: 0;
            pointer-events: none;
            user-select: none;
            -webkit-print-color-adjust: exact;
            print-color-adjust: exact;
        }
        /*.card::before {
            content: '';
            position: absolute;
            inset: 0;
            background: rgba(46,134,222,0.14);
            z-index: 1;
            pointer-events: none;
            -webkit-print-color-adjust: exact;
            print-color-adjust: exact;
        }*/
        .content-wrapper {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            position: relative;
            z-index: 2;
        }
        .qr {
            margin-top: 4mm;
            margin-bottom: 0mm;
            background: #fff;
            padding: 3mm;
            border-radius: 2mm;
            box-shadow: 0 1px 6px #0002;
            display: flex;
            align-items: center;
            justify-content: center;
            -webkit-print-color-adjust: exact;
            print-color-adjust: exact;
        }
        .qr img {
            width: 27mm;
            height: 27mm;
            display: block;
        }
        .member-name {
            bottom: 9mm;
            font-size: 10pt;
            font-weight: bold;
            color: #000;
            text-align: center;
            /*text-shadow: 0 1px 6px #0007;*/
            position: relative;
            z-index: 2;
            -webkit-print-color-adjust: exact;
            print-color-adjust: exact;
        }
        .download-btn {
            margin-top: 18px;
            padding: 10px 28px;
            font-size: 15px;
            border: none;
            border-radius: 3px;
            background: #ffe257;
            color: #222;
            font-weight: bold;
            cursor: pointer;
            box-shadow: 0 1px 4px #0002;
            z-index: 1000;
            display: block;
        }
        @media  print {
            body {
                background: #fff !important;
                min-height: unset;
                display: block;
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }
            .download-btn {
                display: none !important;
            }
            .card {
                margin: 0 !important;
                box-shadow: none !important;
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }
            .card-bg {
                display: block !important;
                opacity: 1 !important;
                visibility: visible !important;
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }
            .card::before {
                background: rgba(46,134,222,0.14) !important;
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }
            .qr, .member-name {
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }
        }
    </style>
    <!-- Tambahkan html2canvas CDN -->
    <script src="https://cdn.jsdelivr.net/npm/html2canvas@1.4.1/dist/html2canvas.min.js"></script>
</head>
<body>
    <div class="card" id="memberCard">
        <img src="<?php echo e(asset('images/gym-card.png')); ?>" class="card-bg" alt="background" />
        <div class="content-wrapper">
            <div class="qr">
                <img src="data:image/png;base64,<?php echo e($qr); ?>">
            </div>
            <p class="member-name"><?php echo e($member->nama); ?></p>
        </div>
    </div>
    <button class="download-btn" onclick="downloadCard()">Download</button>
    <script>
      function downloadCard() {
        const card = document.getElementById('memberCard');
        html2canvas(card, {
          scale: 2,
          backgroundColor: null
        }).then(function(canvas) {
          var link = document.createElement('a');
          link.download = 'member_card_<?php echo e($member->nama); ?>.png';
          link.href = canvas.toDataURL('image/png');
          link.click();
        });
      }
    </script>
</body>
</html><?php /**PATH /home/linm9634/public_html/kasir-gym.linkerapp.my.id/resources/views/members/card.blade.php ENDPATH**/ ?>