<?php $__env->startSection('title', 'Daftar Visitor'); ?>

<?php $__env->startSection('content_header'); ?>
    <h1>Daftar Visitor</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php if(session('success')): ?>
    <div class="alert alert-success"><?php echo e(session('success')); ?></div>
<?php endif; ?>

<div class="d-flex justify-content-between align-items-center mb-3">
    <a href="<?php echo e(route('visitor.create')); ?>" class="btn btn-success btn-sm">
        <i class="fas fa-plus"></i> Tambah Visitor
    </a>
    <form method="GET" action="<?php echo e(route('visitor.index')); ?>" class="d-flex" style="max-width:190px;">
        <div class="input-group input-group-sm">
            <input type="text" name="q" value="<?php echo e(request('q')); ?>" class="form-control" placeholder="Cari nama/kontak/alamat...">
            <button class="btn btn-primary btn-sm" type="submit">
                <i class="fas fa-search"></i>
            </button>
        </div>
    </form>
</div>
<table class="table table-bordered table-hover">
    <thead>
        <tr>
            <th>Nama</th>
            <th>Kontak</th>
            <th>Alamat</th>
            <th>Kunjungan Hari Ini</th>
            <th style="width:280px;">Aksi</th>
        </tr>
    </thead>
    <tbody>
        <?php $__empty_1 = true; $__currentLoopData = $visitors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $visitor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <tr>
            <td><?php echo e($visitor->nama); ?></td>
            <td><?php echo e($visitor->kontak); ?></td>
            <td><?php echo e($visitor->alamat); ?></td>
            <td>
                <?php echo e($visitor->attendances()->where('tanggal', date('Y-m-d'))->count()); ?> x
            </td>
            <td>
                <button class="btn btn-xs btn-info open-visit-modal"
                        data-toggle="modal"
                        data-target="#visitModal"
                        data-visitor-id="<?php echo e($visitor->id); ?>"
                        data-visitor-nama="<?php echo e($visitor->nama); ?>"
                        data-visit-only-price="<?php echo e($visit_only_price ?? ''); ?>">
                    <i class="fas fa-calendar-check"></i> + Kunjungan
                </button>
                <a href="<?php echo e(route('visitor.to-member', $visitor->id)); ?>" class="btn btn-success btn-xs"><i class="fas fa-plus"></i> Member</a>
                <a href="<?php echo e(route('visitor.edit', $visitor->id)); ?>" class="btn btn-warning btn-xs">Edit</a>
            </td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <tr>
            <td colspan="6" class="text-center">Belum ada visitor.</td>
        </tr>
        <?php endif; ?>
    </tbody>
</table>

<div>
    <?php echo e($visitors->links()); ?>

</div>

<div class="modal fade" id="visitModal" tabindex="-1" role="dialog" aria-labelledby="visitModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="visitModalLabel">Tambah Kunjungan: <span id="visitorName"></span></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                
                <input type="hidden" id="currentVisitorId" value="">

                <div class="form-group">
                    <label>Pilih Tipe Kunjungan</label>
                    <select class="form-control tipe-kunjungan" id="tipe-kunjungan" onchange="showVisitFormDynamic()">
                        <option value="">-- Pilih --</option>
                        <option value="mandiri">Latihan Mandiri</option>
                        <option value="pt">Personal Trainer</option>
                    </select>
                </div>

                
                <form id="form-mandiri" method="POST" style="display:none;">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="visit_type" value="mandiri">
                    <input type="hidden" name="harga" id="harga-visit-mandiri-hidden">
                    <div class="form-group">
                        <label>Harga Visit</label>
                        <input type="text" class="form-control" name="harga_display" id="harga-visit-mandiri" readonly>
                    </div>
                    <div class="form-group" id="group-bayar-mandiri">
                        <label>Pembayaran</label>
                        <input type="number" class="form-control bayar-input" name="bayar" id="bayar-mandiri" placeholder="Nominal bayar" required>
                    </div>
                    <div class="form-group" id="group-kembalian-mandiri">
                        <label>Kembalian</label>
                        <input type="text" class="form-control" id="kembalian-mandiri" readonly>
                        <input type="hidden" name="kembalian" id="kembalian-mandiri-hidden">
                    </div>
                    <div class="form-group">
                        <label>Metode Pembayaran</label>
                        <select class="form-control" name="payment_method" required id="payment-mandiri">
                            <option value="cash">Cash</option>
                            <option value="qris">QRIS</option>
                        </select>
                    </div>
                    
                    <div id="qris-container-mandiri" class="text-center" style="display:none;">
                        <img src="<?php echo e(asset('images/qris.png')); ?>" alt="QRIS" class="img-fluid" style="max-width: 200px;">
                    </div>
                    <button type="submit" class="btn btn-success btn-block">Simpan & Cetak Nota</button>
                </form>

                
                <form id="form-pt" method="POST" style="display:none;">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="visit_type" value="pt">
                    <input type="hidden" name="buyer_type" value="visitor">
                    <input type="hidden" name="buyer_id" id="buyer-id-pt">
                    <input type="hidden" name="tanggal" id="tanggal-pt" value="<?php echo e(date('Y-m-d')); ?>">
                    <div class="form-group">
                        <label>Pilih Produk PT</label>
                        <select class="form-control produk-pt" name="produk_id" id="produk-pt" required>
                            <?php $__currentLoopData = $pt_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($product->id); ?>" data-harga="<?php echo e($product->harga); ?>"><?php echo e($product->nama); ?> - Rp <?php echo e(number_format($product->harga,0,',','.')); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Pilih Instruktur</label>
                        <select class="form-control" name="instruktur_id" required>
                            <?php $__currentLoopData = $instructors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ins): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($ins->id); ?>"><?php echo e($ins->nama); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Harga</label>
                        <input type="text" class="form-control" id="harga-pt" readonly>
                        <input type="hidden" name="harga" id="harga-pt-hidden">
                    </div>
                    <div class="form-group">
                        <label>Biaya Masuk</label>
                        <input type="text" class="form-control" id="harga-visit-only-pt" value="Rp <?php echo e(number_format($visit_only_price,0,',','.')); ?>" readonly>
                    </div>
                    <div class="form-group">
                        <label><b>Total Harga (PT + Biaya Masuk)</b></label>
                        <input type="text" class="form-control" id="harga-pt-total" readonly>
                    </div>
                    <div class="form-group" id="group-bayar-pt">
                        <label>Pembayaran</label>
                        <input type="number" class="form-control bayar-input" name="bayar" id="bayar-pt" placeholder="Nominal bayar" required>
                    </div>
                    <div class="form-group" id="group-kembalian-pt">
                        <label>Kembalian</label>
                        <input type="text" class="form-control" id="kembalian-pt" readonly>
                        <input type="hidden" name="kembalian" id="kembalian-pt-hidden">
                    </div>
                    <div class="form-group">
                        <label>Metode Pembayaran</label>
                        <select class="form-control" name="payment_method" required id="payment-pt">
                            <option value="cash">Cash</option>
                            <option value="qris">QRIS</option>
                        </select>
                    </div>
                    
                    <div id="qris-container-pt" class="text-center" style="display:none;">
                        <img src="<?php echo e(asset('images/qris.png')); ?>" alt="QRIS" class="img-fluid" style="max-width: 200px;">
                    </div>
                    <button type="submit" class="btn btn-success btn-block">Simpan & Cetak Nota</button>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script>
// =========================================================================
// UTILITY FUNCTIONS
// =========================================================================

function formatRupiah(angka) {
    angka = angka || 0;
    return "Rp " + angka.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ".");
}

function parseAngka(str) {
    if (typeof str === 'number') {
        return str;
    }
    if (typeof str !== 'string') {
        return 0;
    }
    if (str.startsWith('Rp')) {
        return parseInt(str.replace(/Rp\s?|\./g, '')) || 0;
    }
    return parseInt(str) || 0;
}

// =========================================================================
// GLOBAL CONSTANTS
// =========================================================================

const VISIT_ONLY_PRICE = <?php echo e($visit_only_price ?? 0); ?>;

// =========================================================================
// FORM DISPLAY LOGIC
// =========================================================================

function showVisitFormDynamic() {
    const tipe = $('#tipe-kunjungan').val();
    const visitorId = $('#currentVisitorId').val();

    $('#form-mandiri').hide();
    $('#form-pt').hide();

    if (tipe === 'mandiri') {
        $('#form-mandiri').show();
        $('#harga-visit-mandiri-hidden').val(VISIT_ONLY_PRICE);
        $('#harga-visit-mandiri').val(formatRupiah(VISIT_ONLY_PRICE));
        $('#bayar-mandiri').val('');
        $('#kembalian-mandiri').val(formatRupiah(0));
        $('#kembalian-mandiri-hidden').val(0);
        $('#form-mandiri').attr('action', `/visitor_attendance/visit_mandiri/${visitorId}`);
        
        $('#payment-mandiri').val('cash').trigger('change');
    } else if (tipe === 'pt') {
        $('#form-pt').show();
        $('#buyer-id-pt').val(visitorId);
        $('#tanggal-pt').val(new Date().toISOString().slice(0,10));
        $('#bayar-pt').val('');
        $('#kembalian-pt').val(formatRupiah(0));
        $('#kembalian-pt-hidden').val(0);
        $('#form-pt').attr('action', `/visitor_attendance/visit_pt/${visitorId}`);
        $('#produk-pt').trigger('change');

        $('#payment-pt').val('cash').trigger('change');
    }
}

// =========================================================================
// EVENT LISTENERS
// =========================================================================

$(document).ready(function() {
    $('#form-mandiri').hide();
    $('#form-pt').hide();
    $('#tipe-kunjungan').val('');
});

$(document).on('click', '.open-visit-modal', function () {
    const visitorId = $(this).data('visitor-id');
    const visitorNama = $(this).data('visitor-nama');

    $('#currentVisitorId').val(visitorId);
    $('#buyer-id-pt').val(visitorId);
    $('#visitorName').text(visitorNama);

    $('#tipe-kunjungan').val('');
    $('#form-mandiri').hide();
    $('#form-pt').hide();

    $('#harga-visit-mandiri-hidden').val(0);
    $('#harga-visit-mandiri').val(formatRupiah(0));
    $('#bayar-mandiri').val('');
    $('#kembalian-mandiri').val(formatRupiah(0));
    $('#kembalian-mandiri-hidden').val(0);
    $('#payment-mandiri').val('cash').trigger('change');

    $('#harga-pt-hidden').val(0);
    $('#harga-pt').val(formatRupiah(0));
    $('#bayar-pt').val('');
    $('#kembalian-pt').val(formatRupiah(0));
    $('#kembalian-pt-hidden').val(0);
    $('#payment-pt').val('cash').trigger('change');
});

$(document).on('change', '#produk-pt', function(){
    const hargaPT = parseInt($(this).find(':selected').data('harga')) || 0;
    const total = hargaPT + VISIT_ONLY_PRICE;

    $('#harga-pt').val(formatRupiah(hargaPT));
    $('#harga-visit-only-pt').val(formatRupiah(VISIT_ONLY_PRICE));
    $('#harga-pt-total').val(formatRupiah(total));
    
    $('#harga-pt-hidden').val(total); 
});

$(document).on('input', '#bayar-pt', function(){
    const bayar = parseAngka($(this).val());
    const harga = parseAngka($('#harga-pt-total').val());
    let kembalian = bayar - harga;
    const kembalianFinal = kembalian > 0 ? kembalian : 0;

    $('#kembalian-pt').val(formatRupiah(kembalianFinal));
    $('#kembalian-pt-hidden').val(kembalianFinal);
});

$(document).on('input', '#bayar-mandiri', function(){
    const bayar = parseAngka($(this).val());
    const harga = parseAngka($('#harga-visit-mandiri-hidden').val());
    let kembalian = bayar - harga;
    const kembalianFinal = kembalian > 0 ? kembalian : 0;

    $('#kembalian-mandiri').val(formatRupiah(kembalianFinal));
    $('#kembalian-mandiri-hidden').val(kembalianFinal);
});

// Event listener untuk pilihan metode pembayaran Mandiri
$(document).on('change', '#payment-mandiri', function(){
    if ($(this).val() === 'qris') {
        $('#qris-container-mandiri').show();
        $('#group-bayar-mandiri').hide();
        $('#group-kembalian-mandiri').hide();
        $('#bayar-mandiri').prop('required', false).val(0);
        $('#kembalian-mandiri-hidden').val(0);
    } else {
        $('#qris-container-mandiri').hide();
        $('#group-bayar-mandiri').show();
        $('#group-kembalian-mandiri').show();
        $('#bayar-mandiri').prop('required', true);
    }
});

// Event listener untuk pilihan metode pembayaran PT
$(document).on('change', '#payment-pt', function(){
    if ($(this).val() === 'qris') {
        $('#qris-container-pt').show();
        $('#group-bayar-pt').hide();
        $('#group-kembalian-pt').hide();
        $('#bayar-pt').prop('required', false).val(0);
        $('#kembalian-pt-hidden').val(0);
    } else {
        $('#qris-container-pt').hide();
        $('#group-bayar-pt').show();
        $('#group-kembalian-pt').show();
        $('#bayar-pt').prop('required', true);
    }
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/gym/gym-membership/resources/views/visitor/index.blade.php ENDPATH**/ ?>