<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Cetak Struk</title>
    <style>
body {
    font-family: monospace, 'Courier New', Courier;
    font-size: 14px;
    background: #fff;
    width: 80mm;
    min-width: 80mm;
    max-width: 80mm;
    margin: 2mm;
    padding: 0;
    box-sizing: border-box;
}

.struk {
    width: 76mm; /* 80mm - (2mm margin * 2) */
    margin: 0 auto;
    padding: 0;
}

.center {
    text-align: center;
}

.bold {
    font-weight: bold;
}

.line {
    border-top: 1px dashed #000;
    margin: 8px 0;
}

table {
    width: 100%;
    border-collapse: collapse;
}

td {
    vertical-align: top;
    padding: 0;
    margin: 0;
}

/* Sembunyikan tombol atau elemen lain yang tidak perlu dicetak */
#backBtn {
    display: none;
}

/* Aturan media print memastikan properti ini hanya diterapkan saat mencetak */
@media  print {
    html, body {
        width: 80mm !important;
        min-width: 80mm !important;
        max-width: 80mm !important;
        margin: 2mm !important;
        padding: 0 !important;
        background: #fff !important;
        box-sizing: border-box;
    }
    .struk {
        width: 76mm !important; /* Memperhitungkan margin */
        min-width: 76mm !important;
        max-width: 76mm !important;
        margin: 0 auto !important;
        padding: 0 !important;
    }
    #backBtn {
        display: none !important;
    }
}
    </style>
</head>
<body>
    <div class="struk">
        <div class="center bold" style="margin-bottom:2px;">
            <!--BOOSTER FITNESS CENTER-->
            <img src="<?php echo e(asset('images/logobw.png')); ?>" style="width: 180px; height: 40px;" class="fill-current"> 
        </div>
        <div class="center" style="margin-bottom:2px;">
            Jl. Grompol-Jambangan,Bekon,RT01<br>
            RW01,Karangmalang,Masaran<br>
            0852-0068-2000
        </div>
        <div class="line"></div>
        <table>
            <tr>
                <td>Tanggal</td>
                <td>: <?php echo e($trx->tanggal); ?></td>
            </tr>
            <tr>
                <td>Pembeli</td>
                <td>: <?php echo e($trx->member ? $trx->member->nama : ($trx->visitor ? $trx->visitor->nama : '-')); ?></td>
            </tr>
            <tr>
                <td>Paket</td>
                <td>: <?php echo e($trx->product->nama ?? '-'); ?></td>
            </tr>
            <tr>
                <td>Instruktur</td>
                <td>: <?php echo e($trx->instruktur->nama ?? '-'); ?></td>
            </tr>
        </table>
        <div class="line"></div>
        <table>
            <tr>
                <td>Harga</td>
                <td style="text-align:right;">Rp <?php echo e(number_format($trx->harga,0,',','.')); ?></td>
            </tr>
            <tr>
                <td>Bayar</td>
                <td style="text-align:right;"><?php echo e(ucfirst($trx->payment_method)); ?></td>
            </tr>
        </table>
        <div class="line"></div>
        <div class="center">Terima kasih!</div>
        <div class="center"><?php echo e(now()->format('d/m/Y H:i')); ?></div>
        <br>.
        <br>.
        <!--<button id="backBtn">Kembali</button>-->
    </div>
<script>
    window.onload = function() {
        window.print();
    }
</script>
</body>
</html><?php /**PATH /home/linm9634/public_html/kasir-gym.linkerapp.my.id/resources/views/pt_purchases/print.blade.php ENDPATH**/ ?>