<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-6">
            <div class="card mt-4">
                <div class="card-header">
                    <h3 class="card-title mb-0">Scan QR Kartu Member untuk Absensi</h3>
                </div>
                <div class="card-body">
                    <div id="qr-reader" style="width:320px"></div>
                    <div id="qr-result" class="mt-3"></div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<!-- html5-qrcode CDN -->
<script src="https://unpkg.com/html5-qrcode@2.3.7/html5-qrcode.min.js"></script>
<script>
function onScanSuccess(decodedText, decodedResult) {
    $.ajax({
        url: "/absensi/scan",
        method: "POST",
        data: {
            kode: decodedText,
            _token: "<?php echo e(csrf_token()); ?>"
        },
        success: function(res) {
            let color = res.status === 'success' ? 'success' : (res.status === 'info' ? 'warning' : 'danger');
            $('#qr-result').html('<div class="alert alert-'+color+'">'+res.message+'</div>');
        },
        error: function() {
            $('#qr-result').html('<div class="alert alert-danger">Terjadi kesalahan server.</div>');
        }
    });
}

$(document).ready(function(){
    let qr = new Html5QrcodeScanner(
        "qr-reader", { fps: 10, qrbox: 250 }
    );
    qr.render(onScanSuccess);
});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/linm9634/public_html/kasir-gym.linkerapp.my.id/resources/views/absensi/index.blade.php ENDPATH**/ ?>