<?php $__env->startSection('title', 'Daftar Personal Trainer'); ?>
<?php $__env->startSection('content_header'); ?>
    <h1>Daftar Personal Trainer</h1>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<a href="<?php echo e(route('instrukturs.create')); ?>" class="btn btn-sm btn-primary mb-3"><i class="fas fa-plus"></i>Tambah PT</a>
<?php if(session('success')): ?>
    <div class="alert alert-success"><?php echo e(session('success')); ?></div>
<?php endif; ?>
<table class="table table-bordered">
    <thead>
        <tr>
            <th>Nama</th>
            <th>Kontak</th>
            <th>Alamat</th>
            <th>Aksi</th>
        </tr>
    </thead>
    <tbody>
        <?php $__currentLoopData = $instrukturs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td><a href="<?php echo e(route('instrukturs.show', $pt->id)); ?>"><?php echo e($pt->nama); ?></a></td>
            <td><?php echo e($pt->kontak); ?></td>
            <td><?php echo e($pt->alamat); ?></td>
            <td>
                <a href="<?php echo e(route('instrukturs.edit', $pt->id)); ?>" class="btn btn-warning btn-sm">Edit</a>
                || <?php if(auth()->user()->role == 'admin'): ?>
                <form action="<?php echo e(route('instrukturs.destroy', $pt->id)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Yakin hapus?')">
                    <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                    <button class="btn btn-danger btn-sm">Hapus</button>
                </form>
                <?php endif; ?>
            </td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>

<div class="mt-3">
    <?php echo e($instrukturs->links()); ?>

</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/linm9634/public_html/kasir-gym.linkerapp.my.id/resources/views/instrukturs/index.blade.php ENDPATH**/ ?>