<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Gym Member Card</title>
    <style>
        body {
            background: #222;
            margin: 0;
            padding: 0;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .card {
            width: 87mm;
            height: 54mm;
            border-radius: 0mm;
            border: 1px solid #f5f3f0;
            position: relative;
            overflow: hidden;
            font-family: 'Segoe UI', Arial, sans-serif;
            box-sizing: border-box;
            display: flex;
            flex-direction: column;
            justify-content: flex-start; /* Mengembalikan ke atas untuk penyesuaian baru */
            align-items: center;
            padding-top: 7mm; /* Tambahkan padding 5mm dari atas */
        }
        /* Gambar background sebagai elemen img agar pasti ikut print di Android */
        .card-bg {
            position: absolute;
            inset: 0;
            width: 100%;
            height: 100%;
            object-fit: cover;
            z-index: 0;
            pointer-events: none;
            user-select: none;
            -webkit-print-color-adjust: exact;
            print-color-adjust: exact;
        }
        .card::before {
            content: '';
            position: absolute;
            inset: 0;
            background: rgba(46,134,222,0.14);
            z-index: 1;
            pointer-events: none;
            -webkit-print-color-adjust: exact;
            print-color-adjust: exact;
        }
        .content-wrapper {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            position: relative;
            z-index: 2;
        }
        .qr {
            margin-bottom: 0mm;
            background: #fff;
            padding: 3mm;
            border-radius: 3mm;
            box-shadow: 0 1px 6px #0002;
            display: flex;
            align-items: center;
            justify-content: center;
            -webkit-print-color-adjust: exact;
            print-color-adjust: exact;
        }
        .qr img {
            width: 27mm;
            height: 27mm;
            display: block;
        }
        .member-name {
            font-size: 13pt;
            font-weight: bold;
            color: #fff;
            text-align: center;
            text-shadow: 0 1px 6px #0007;
            position: relative;
            z-index: 2;
            -webkit-print-color-adjust: exact;
            print-color-adjust: exact;
        }
        .print-btn {
            position: fixed;
            top: 20px;
            left: 20px;
            padding: 7px 18px;
            font-size: 13px;
            border: none;
            border-radius: 3px;
            background: #ffe257;
            color: #222;
            font-weight: bold;
            cursor: pointer;
            z-index: 1000;
            box-shadow: 0 1px 4px #0002;
        }
        @media  print {
            body {
                background: #fff !important;
                min-height: unset;
                display: block;
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }
            .print-btn {
                display: none !important;
            }
            .card {
                margin: 0 !important;
                box-shadow: none !important;
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }
            .card-bg {
                display: block !important;
                opacity: 1 !important;
                visibility: visible !important;
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }
            .card::before {
                background: rgba(46,134,222,0.14) !important;
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }
            .qr, .member-name {
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }
        }
    </style>
</head>
<body>
    <button class="print-btn" onclick="window.print()">Print</button>
    <div class="card">
        <img src="<?php echo e(asset('images/gym-card.png')); ?>" class="card-bg" alt="background" />
        <div class="content-wrapper">
            <div class="qr">
                <img src="data:image/png;base64,<?php echo e($qr); ?>">
            </div>
            <p class="member-name"><?php echo e($member->nama); ?></p>
        </div>
    </div>
</body>
</html><?php /**PATH /var/www/html/gym/gym-membership/resources/views/members/card.blade.php ENDPATH**/ ?>