<?php $__env->startSection('title', 'Daftar Pembelian Produk'); ?>

<?php $__env->startSection('content_header'); ?>
    <h1>Daftar Pembelian Produk</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php if(session('success')): ?>
    <div class="alert alert-success"><?php echo e(session('success')); ?></div>
<?php endif; ?>


<form method="GET" action="<?php echo e(route('purchases.index')); ?>" class="form-inline mb-3">
    <div class="form-group mr-2">
        <input type="date" name="tanggal_mulai" class="form-control" value="<?php echo e(request('tanggal_mulai')); ?>">
    </div>
    <span class="mr-2">s/d</span>
    <div class="form-group mr-2">
        <input type="date" name="tanggal_selesai" class="form-control" value="<?php echo e(request('tanggal_selesai')); ?>">
    </div>
    <div class="form-group mr-2">
        <input type="text" name="q" class="form-control" placeholder="Cari pembeli/produk" value="<?php echo e(request('q')); ?>">
    </div>
    <button type="submit" class="btn btn-info mr-2">Filter</button>
    <a href="<?php echo e(route('purchases.index')); ?>" class="btn btn-secondary">Reset</a>
</form>

<a href="<?php echo e(route('purchases.create')); ?>" class="btn btn-primary mb-3">Transaksi Baru</a>
<div class="table-responsive">
    <table class="table table-bordered table-striped">
        <thead>
            <tr>
                <th>#</th>
                <th>Tanggal</th>
                <th>Pembeli</th>
                <th>Alamat</th>
                <th>Total</th>
                <th>Aksi</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $purchases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><?php echo e($purchases->firstItem() + $i); ?></td>
                    <td><?php echo e(\Carbon\Carbon::parse($p->tanggal)->format('d-m-Y H:i:s')); ?></td>
                    <td>
                        <?php if(is_object($p->member) && isset($p->member->nama)): ?>
                            <?php echo e($p->member->nama); ?>

                        <?php elseif(!empty($p->nama_pembeli)): ?>
                            <?php echo e($p->nama_pembeli); ?> <em>(Non Member)</em>
                        <?php else: ?>
                            -
                        <?php endif; ?>
                    </td>
                    <td><?php echo e($p->alamat_pembeli); ?></td>
                    <td>
                        <span
                            data-toggle="tooltip"
                            data-placement="top"
                            title="<?php
                                echo $p->details
                                    ? collect($p->details)->map(function($d){
                                        return (isset($d->product) && isset($d->product->nama)
                                            ? $d->product->nama
                                            : 'Produk tidak ditemukan'
                                        ) . ' x' . $d->qty;
                                    })->implode(', ')
                                    : '';
                            ?>"
                        >
                            <?php echo e(number_format($p->total_harga,0,',','.')); ?>

                        </span>
                        <button type="button" class="btn btn-xs btn-info" data-toggle="modal" data-target="#modal-<?php echo e($p->id); ?>">
                          <i class="fa fa-eye"></i>
                        </button>
                        <?php echo e($p->payment_method); ?>

                        <!-- Modal -->
                        <div class="modal fade" id="modal-<?php echo e($p->id); ?>" tabindex="-1">
                          <div class="modal-dialog">
                            <div class="modal-content">
                              <div class="modal-header">
                                <h5 class="modal-title">Detail Produk</h5>
                                <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
                              </div>
                              <div class="modal-body">
                                <ul>
                                  <?php $__currentLoopData = $p->details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li>
                                        <?php if(isset($detail->product) && isset($detail->product->nama)): ?>
                                            <?php echo e($detail->product->nama); ?> x<?php echo e($detail->qty); ?>

                                        <?php else: ?>
                                            Produk ID: <?php echo e($detail->product_id ?? '-'); ?> tidak ditemukan x<?php echo e($detail->qty); ?>

                                        <?php endif; ?>
                                    </li>
                                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                              </div>
                            </div>
                          </div>
                        </div>
                    </td>
                    <td>
                        
                        <a href="<?php echo e(route('purchases.print', $p->id)); ?>" target="_blank" class="btn btn-xs btn-success">
                            <i class="fa fa-print"></i> cetak 
                        </a>
                        
                        <?php if(auth()->user()->role == 'admin'): ?>
                        ||
                            <form action="<?php echo e(route('purchases.destroy', $p->id)); ?>" method="POST" style="display:inline" onsubmit="return confirm('Yakin hapus transaksi ini?');">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button class="btn btn-xs btn-danger" type="submit"><i class="fa fa-trash"></i> hapus</button>
                        </form>
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr><td colspan="5" class="text-center">Belum ada data pembelian</td></tr>
            <?php endif; ?>
        </tbody>
    </table>
    <?php echo e($purchases->links()); ?>


    <div class="mt-2">
        <strong>Total Transaksi: Rp <?php echo e(number_format($totalTransaksi,0,',','.')); ?></strong>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script>
$(function () {
  $('[data-toggle="tooltip"]').tooltip()
})
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/linm9634/public_html/kasir-gym.linkerapp.my.id/resources/views/purchases/index.blade.php ENDPATH**/ ?>