<?php $__env->startSection('title', 'Produk'); ?>

<?php $__env->startSection('content_header'); ?>
    <h1>Kelola Produk</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php if(session('success')): ?>
    <div class="alert alert-success"><?php echo e(session('success')); ?></div>
<?php endif; ?>

<form method="GET" action="<?php echo e(route('produk.index')); ?>" class="form-inline mb-3">
    <input type="text" name="q" class="form-control mr-2" value="<?php echo e($q ?? ''); ?>" placeholder="Cari nama/kategori produk">
    <button class="btn btn-primary" type="submit">Cari</button>
    <?php if($q): ?>
        <a href="<?php echo e(route('produk.index')); ?>" class="btn btn-default ml-2">Reset</a>
    <?php endif; ?>
    <a href="<?php echo e(route('produk.create')); ?>" class="btn btn-success ml-auto">Tambah Produk</a>
</form>

<div class="table-responsive">
    <table class="table table-bordered table-striped">
        <thead>
            <tr>
                <th>#</th>
                <th>Nama Produk</th>
                <th>Kategori</th>
                <th>Stok</th>
                <th>Harga</th>
                <th>Aksi</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><?php echo e($products->firstItem() + $i); ?></td>
                    <td><?php echo e($p->nama); ?></td>
                    <td><?php echo e(ucfirst(str_replace('_',' ', $p->kategori))); ?></td>
                    <td><?php echo e($p->stok); ?></td>
                    <td><?php echo e(number_format($p->harga,0,',','.')); ?></td>
                    <td>
                        <form action="<?php echo e(route('produk.restok', $p)); ?>" method="POST" class="d-inline">
                            <?php echo csrf_field(); ?>
                            <input type="number" name="jumlah" min="1" class="form-control d-inline" style="width: 80px;" required>
                            <button type="submit" class="btn btn-success btn-sm">Restok</button>
                        </form>
                        <a href="<?php echo e(route('produk.edit', $p)); ?>" class="btn btn-warning btn-sm">Edit</a>
                        <?php if(auth()->user()->role == 'admin'): ?>
                        <form method="POST" action="<?php echo e(route('produk.destroy', $p)); ?>" style="display:inline" onsubmit="return confirm('Hapus produk ini?')">
                            <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                            <button class="btn btn-danger btn-sm" type="submit">Hapus</button>
                        </form>
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr><td colspan="6" class="text-center">Belum ada produk</td></tr>
            <?php endif; ?>
        </tbody>
    </table>
    <?php echo e($products->links()); ?>

</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/gym/gym-membership/resources/views/produk/index.blade.php ENDPATH**/ ?>