<?php $__env->startSection('title', 'Data Transaksi PT'); ?>
<?php $__env->startSection('content_header'); ?>
    <h1>Data Transaksi PT</h1>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<?php if(session('success')): ?>
    <div class="alert alert-success"><?php echo e(session('success')); ?></div>
<?php endif; ?>
<a href="<?php echo e(route('pt_purchases.create')); ?>" class="btn btn-sm btn-primary mb-3"><i class="fas fa-plus"></i>
Tambah Transaksi PT</a>
<form method="GET" class="form-row align-items-center mb-3" style="gap:8px;">
    <!--<div class="col-auto">
        <select name="bulan" class="form-control form-control-sm" title="Bulan">
            <?php for($m=1;$m<=12;$m++): ?>
                <option value="<?php echo e(sprintf('%02d', $m)); ?>" <?php echo e($bulan == sprintf('%02d', $m) ? 'selected' : ''); ?>>
                    <?php echo e(DateTime::createFromFormat('!m', $m)->format('M')); ?>

                </option>
            <?php endfor; ?>
        </select>
    </div>
    <div class="col-auto">
        <select name="tahun" class="form-control form-control-sm" title="Tahun">
            <?php for($y = date('Y')-2; $y <= date('Y')+1; $y++): ?>
                <option value="<?php echo e($y); ?>" <?php echo e($tahun == $y ? 'selected' : ''); ?>><?php echo e($y); ?></option>
            <?php endfor; ?>
        </select>
    </div>-->
    <div class="col-auto">
        <input type="date" name="tanggal_awal" value="<?php echo e($tanggal_awal); ?>" class="form-control form-control-sm" title="Tgl Awal">
    </div>
    <div class="col-auto">
        <input type="date" name="tanggal_akhir" value="<?php echo e($tanggal_akhir); ?>" class="form-control form-control-sm" title="Tgl Akhir">
    </div>
    <div class="col-auto">
        <input type="text" name="search" value="<?php echo e($search); ?>" class="form-control form-control-sm" placeholder="Cari nama">
    </div>
    <div class="col-auto">
        <button type="submit" class="btn btn-info btn-sm">Filter</button>
        <a href="<?php echo e(route('pt_purchases.index')); ?>" class="btn btn-secondary btn-sm">Reset</a>
    </div>
</form>
<table class="table table-bordered">
    <thead>
        <tr>
            <th>Tanggal</th>
            <th>Pembeli</th>
            <th>Paket/PT Visit</th>
            <th>Instruktur</th>
            <th>Harga</th>
            <th>Pembayaran</th>
            <th>Aksi</th>
        </tr>
    </thead>
    <tbody>
        <?php $__currentLoopData = $purchases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trx): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td><?php echo e($trx->tanggal); ?></td>
            <td>
                <?php echo e($trx->member ? $trx->member->nama : ($trx->visitor ? $trx->visitor->nama : '-')); ?>

            </td>
            <td><?php echo e($trx->product->nama ?? '-'); ?></td>
            <td><?php echo e($trx->instruktur->nama ?? '-'); ?></td>
            <td>Rp <?php echo e(number_format($trx->harga)); ?></td>
            <td><?php echo e(ucfirst($trx->payment_method)); ?></td>
            <td>
                <a href="<?php echo e(route('pt_purchases.print', $trx->id)); ?>" target="_blank" class="btn btn-xs btn-success"><i class="fas fa-print"></i>
                Cetak Struk</a>
                <?php if(auth()->user()->role == 'admin'): ?>
                || 
                    <form action="<?php echo e(route('pt_purchases.destroy', $trx->id)); ?>" method="POST" style="display:inline;" onsubmit="return confirm('Yakin hapus transaksi PT ini?')">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="submit" class="btn btn-xs btn-danger"><i class="fas fa-trash"></i> Hapus</button>
                    </form>
                <?php endif; ?>
            </td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
<strong>Total Transaksi (<?php echo e($bulan); ?>/<?php echo e($tahun); ?><?php echo e($tanggal_awal && $tanggal_akhir ? " | $tanggal_awal s/d $tanggal_akhir" : ""); ?>):</b>
    Rp <?php echo e(number_format($total)); ?></strong>
<div class="mt-3">
    <?php echo e($purchases->links()); ?>

</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/linm9634/public_html/kasir-gym.linkerapp.my.id/resources/views/pt_purchases/index.blade.php ENDPATH**/ ?>