<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return redirect('/login');
});

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth'])->name('dashboard');

require __DIR__.'/auth.php';

use App\Http\Controllers\MemberController;
use App\Http\Controllers\AbsenceController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\PurchaseController;
use App\Http\Controllers\PersonalTrainerController;
use App\Http\Controllers\PTSessionController;
use App\Http\Controllers\PTVisitController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\VisitorController;
use App\Http\Controllers\VisitorAttendanceController;
use App\Http\Controllers\DashboardController;

Route::middleware(['auth'])->group(function () {
    Route::resource('members', MemberController::class);
    Route::resource('absences', AbsenceController::class);
    //Route::resource('products', ProductController::class);
    //Route::resource('purchases', PurchaseController::class);
    Route::resource('pt', PersonalTrainerController::class);
    //Route::resource('pt_sessions', PTSessionController::class);
    Route::resource('pt_visits', PTVisitController::class);
    Route::resource('notifications', NotificationController::class);
    Route::get('/members/{id}/card', [MemberController::class, 'card'])->name('members.card');
    Route::get('/members', [MemberController::class, 'index'])->name('members.index');
    Route::get('/absensi', [AbsenceController::class, 'index'])->name('absensi.index');
    Route::post('/absensi/scan', [AbsenceController::class, 'scan'])->name('absensi.scan');
    Route::get('/absensi/riwayat', [AbsenceController::class, 'history'])->name('absensi.history');
    Route::get('/absensi/rekap', [AbsenceController::class, 'rekap']);
    Route::resource('produk', ProductController::class);
    Route::resource('purchases', PurchaseController::class)->only(['index', 'create', 'store']);
    Route::delete('purchases/{purchase}', [PurchaseController::class, 'destroy'])->name('purchases.destroy');
    Route::get('purchases/{purchase}/print', [PurchaseController::class, 'print'])->name('purchases.print');
    Route::post('produk/{produk}/restok', [ProductController::class, 'restok'])->name('produk.restok');
    Route::get('/pt-sessions/create', [PTSessionController::class, 'create'])->name('pt-sessions.create');
    Route::post('/pt-sessions', [PTSessionController::class, 'store'])->name('pt-sessions.store');
    // Visitor
    Route::prefix('visitor')->name('visitor.')->group(function () {
        Route::get('/', [VisitorController::class, 'index'])->name('index');
        Route::get('/create', [VisitorController::class, 'create'])->name('create');
        Route::post('/store', [VisitorController::class, 'store'])->name('store');
        Route::get('/{id}/to-member', [VisitorController::class, 'toMember'])->name('to-member');
        Route::post('/{id}/store-member', [VisitorController::class, 'storeMember'])->name('store-member');
        Route::delete('/{id}', [VisitorController::class, 'destroy'])->name('destroy');
        Route::get('/{id}/edit', [VisitorController::class, 'edit'])->name('edit');
        Route::put('/{id}', [VisitorController::class, 'update'])->name('update');
    });
    Route::resource('instrukturs', \App\Http\Controllers\InstrukturController::class);
    Route::resource('pt_purchases', \App\Http\Controllers\PtPurchaseController::class)->only(['index', 'create', 'store']);
    Route::delete('pt_purchases/{pt_purchase}', [App\Http\Controllers\PtPurchaseController::class, 'destroy'])->name('pt_purchases.destroy');
    Route::get('pt_purchases/{id}/print', [\App\Http\Controllers\PtPurchaseController::class, 'print'])->name('pt_purchases.print');
    //Route::post('visitor-attendance/add/{id}', [VisitorAttendanceController::class, 'add'])->name('visitor_attendance.add');
    Route::get('visitor-attendance/rekap', [VisitorAttendanceController::class, 'rekap'])
        ->name('visitor_attendance.rekap');
    Route::post('/visitor_attendance/visit_mandiri/{visitor_id}', [VisitorAttendanceController::class, 'visit_mandiri'])->name('visitor_attendance.visit_mandiri');
    Route::post('visitor_attendance/visit_pt/{id}', [VisitorAttendanceController::class, 'visit_pt'])->name('visitor_attendance.visit_pt');
    Route::get('/visitor_attendance/struk_mandiri/{attendance_id}', [VisitorAttendanceController::class, 'strukMandiri'])->name('visitor_attendance.struk_mandiri');
    Route::delete('/visitor-attendance/{visitor}', [VisitorAttendanceController::class, 'destroy'])->name('visitor_attendance.destroy');
    Route::get('/pt_purchases/print/{id}', [VisitorAttendanceController::class, 'strukPT'])->name('pt_purchase.print');
    Route::get('/visitor/struk_pt/{ptPurchaseId}', [\App\Http\Controllers\VisitorAttendanceController::class, 'struk_pt'])
        ->name('visitor.struk_pt');
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

});
