<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Models\Member;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::get('/member-by-qr/{qr}', function($qr) {
    $member = Member::where('qr_code', $qr)
        ->orWhere('id', $qr)
        ->first();
    if ($member) {
        return response()->json($member);
    } else {
        return response()->json(['id'=>null]);
    }
});
