@extends('adminlte::page')

@section('title', 'Rekap Kehadiran Visitor')

@section('content_header')
    <h1>Rekap Kehadiran Visitor</h1>
@stop

@section('content')
<div class="mb-3">
    <form class="form-inline" method="GET">
        <label class="mr-2">Tanggal</label>
        <input type="date" name="tanggal_awal" class="form-control form-control-sm mr-2" value="{{ request('tanggal_awal', $tanggal_awal) }}">
        <span class="mr-2">s/d</span>
        <input type="date" name="tanggal_akhir" class="form-control form-control-sm mr-2" value="{{ request('tanggal_akhir', $tanggal_akhir) }}">
        <button class="btn btn-info btn-sm">Tampilkan</button>
    </form>
</div>

<table class="table table-bordered table-hover">
    <thead>
        <tr>
            <th>Nama Visitor</th>
            <th>Kontak</th>
            <th>Alamat</th>
            <th>Jumlah Kunjungan</th>
            <th>Pendapatan</th>
            <th>@if(auth()->user()->role == 'admin')
                Aksi
                @endif
            </th>
        </tr>
    </thead>
    <tbody>
        @php $total_semua = 0; @endphp
        @foreach($rekap as $v)
        @php $total_semua += $v->total_pendapatan; @endphp
        <tr>
            <td>{{ $v->nama }}</td>
            <td>{{ $v->kontak }}</td>
            <td>{{ $v->alamat }}</td>
            <td>{{ $v->jumlah_kunjungan }}</td>
            <td>Rp {{ number_format($v->total_pendapatan, 0, ',', '.') }}</td>
            <td>
                @if(auth()->user()->role == 'admin')
                <form action="{{ route('visitor_attendance.destroy', $v->id) }}" method="POST" onsubmit="return confirm('Yakin hapus semua data kehadiran visitor ini?')">
                    @csrf
                    @method('DELETE')
                    <button class="btn btn-danger btn-xs" type="submit">Hapus</button>
                </form>
                 @endif
            </td>            
        </tr>
        @endforeach
        <tr>
            <th colspan="4" class="text-right">Total Pendapatan</th>
            <th>Rp {{ number_format($total_semua, 0, ',', '.') }}</th>
        </tr>
    </tbody>
</table>

@endsection