@extends('adminlte::page')

@section('title', 'Daftar Pembelian Produk')

@section('content_header')
    <h1>Daftar Pembelian Produk</h1>
@stop

@section('content')
@if(session('success'))
    <div class="alert alert-success">{{ session('success') }}</div>
@endif

{{-- Filter Form --}}
<form method="GET" action="{{ route('purchases.index') }}" class="form-inline mb-3">
    <div class="form-group mr-2">
        <input type="date" name="tanggal_mulai" class="form-control" value="{{ request('tanggal_mulai') }}">
    </div>
    <span class="mr-2">s/d</span>
    <div class="form-group mr-2">
        <input type="date" name="tanggal_selesai" class="form-control" value="{{ request('tanggal_selesai') }}">
    </div>
    <div class="form-group mr-2">
        <input type="text" name="q" class="form-control" placeholder="Cari pembeli/produk" value="{{ request('q') }}">
    </div>
    <button type="submit" class="btn btn-info mr-2">Filter</button>
    <a href="{{ route('purchases.index') }}" class="btn btn-secondary">Reset</a>
</form>

<a href="{{ route('purchases.create') }}" class="btn btn-primary mb-3">Transaksi Baru</a>
<div class="table-responsive">
    <table class="table table-bordered table-striped">
        <thead>
            <tr>
                <th>#</th>
                <th>Tanggal</th>
                <th>Pembeli</th>
                <th>Alamat</th>
                <th>Total</th>
                <th>Aksi</th>
            </tr>
        </thead>
        <tbody>
            @forelse($purchases as $i => $p)
                <tr>
                    <td>{{ $purchases->firstItem() + $i }}</td>
                    <td>{{ \Carbon\Carbon::parse($p->tanggal)->format('d-m-Y H:i:s') }}</td>
                    <td>
                        @if(is_object($p->member) && isset($p->member->nama))
                            {{ $p->member->nama }}
                        @elseif(!empty($p->nama_pembeli))
                            {{ $p->nama_pembeli }} <em>(Non Member)</em>
                        @else
                            -
                        @endif
                    </td>
                    <td>{{ $p->alamat_pembeli}}</td>
                    <td>
                        <span
                            data-toggle="tooltip"
                            data-placement="top"
                            title="@php
                                echo $p->details
                                    ? collect($p->details)->map(function($d){
                                        return (isset($d->product) && isset($d->product->nama)
                                            ? $d->product->nama
                                            : 'Produk tidak ditemukan'
                                        ) . ' x' . $d->qty;
                                    })->implode(', ')
                                    : '';
                            @endphp"
                        >
                            {{ number_format($p->total_harga,0,',','.') }}
                        </span>
                        <button type="button" class="btn btn-xs btn-info" data-toggle="modal" data-target="#modal-{{ $p->id }}">
                          <i class="fa fa-eye"></i>
                        </button>
                        {{ $p->payment_method }}
                        <!-- Modal -->
                        <div class="modal fade" id="modal-{{ $p->id }}" tabindex="-1">
                          <div class="modal-dialog">
                            <div class="modal-content">
                              <div class="modal-header">
                                <h5 class="modal-title">Detail Produk</h5>
                                <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
                              </div>
                              <div class="modal-body">
                                <ul>
                                  @foreach($p->details as $detail)
                                    <li>
                                        @if(isset($detail->product) && isset($detail->product->nama))
                                            {{ $detail->product->nama }} x{{ $detail->qty }}
                                        @else
                                            Produk ID: {{ $detail->product_id ?? '-' }} tidak ditemukan x{{ $detail->qty }}
                                        @endif
                                    </li>
                                  @endforeach
                                </ul>
                              </div>
                            </div>
                          </div>
                        </div>
                    </td>
                    <td>
                        {{-- Aksi lain jika diperlukan --}}
                        <a href="{{ route('purchases.print', $p->id) }}" target="_blank" class="btn btn-xs btn-success">
                            <i class="fa fa-print"></i> cetak 
                        </a>
                        
                        @if(auth()->user()->role == 'admin')
                        ||
                            <form action="{{ route('purchases.destroy', $p->id) }}" method="POST" style="display:inline" onsubmit="return confirm('Yakin hapus transaksi ini?');">
                            @csrf
                            @method('DELETE')
                            <button class="btn btn-xs btn-danger" type="submit"><i class="fa fa-trash"></i> hapus</button>
                        </form>
                        @endif
                    </td>
                </tr>
            @empty
                <tr><td colspan="5" class="text-center">Belum ada data pembelian</td></tr>
            @endforelse
        </tbody>
    </table>
    {{ $purchases->links() }}

    <div class="mt-2">
        <strong>Total Transaksi: Rp {{ number_format($totalTransaksi,0,',','.') }}</strong>
    </div>
</div>
@stop

@section('js')
<script>
$(function () {
  $('[data-toggle="tooltip"]').tooltip()
})
</script>
@stop