@extends('adminlte::page')

@section('title', 'Tambah Sesi PT')

@section('content_header')
    <h1>Tambah Sesi Personal Trainer</h1>
@stop

@section('content')
    <div class="card card-primary">
        <div class="card-header">
            <h3 class="card-title">Form Tambah Sesi</h3>
        </div>
        <form method="POST" action="{{ route('pt-sessions.store') }}">
            @csrf
            <div class="card-body">
                <div class="form-group">
                    <label for="personal_trainer_id">Personal Trainer</label>
                    <select class="form-control" name="personal_trainer_id" id="personal_trainer_id" required>
                        <option value="">Pilih PT</option>
                        @foreach($pts as $pt)
                            <option value="{{ $pt->id }}">{{ $pt->nama }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="form-group">
                    <label for="waktu">Tanggal & Waktu</label>
                    <input type="datetime-local" class="form-control" name="waktu" id="waktu" required>
                </div>
                <x-adminlte-select name="member_id" label="Member" required>
                    <option value="">-- Pilih Member --</option>
                        @foreach($members as $member)
                            <option value="{{ $member->id }}" {{ old('member_id') == $member->id ? 'selected' : '' }}>
                            {{ $member->nama }}
                            </option>
                        @endforeach
                </x-adminlte-select>
            </div>
            <div class="card-footer">
                <button type="submit" class="btn btn-primary">Tambah Sesi</button>
                <a href="{{ route('pt.index') }}" class="btn btn-default">Kembali</a> 
            </div>
            </form>
    </div>
    @stop