@extends('adminlte::page')
@section('title', 'Data Transaksi PT')
@section('content_header')
    <h1>Data Transaksi PT</h1>
@stop
@section('content')
@if(session('success'))
    <div class="alert alert-success">{{ session('success') }}</div>
@endif
<a href="{{ route('pt_purchases.create') }}" class="btn btn-sm btn-primary mb-3"><i class="fas fa-plus"></i>
Tambah Transaksi PT</a>
<form method="GET" class="form-row align-items-center mb-3" style="gap:8px;">
    <!--<div class="col-auto">
        <select name="bulan" class="form-control form-control-sm" title="Bulan">
            @for($m=1;$m<=12;$m++)
                <option value="{{ sprintf('%02d', $m) }}" {{ $bulan == sprintf('%02d', $m) ? 'selected' : '' }}>
                    {{ DateTime::createFromFormat('!m', $m)->format('M') }}
                </option>
            @endfor
        </select>
    </div>
    <div class="col-auto">
        <select name="tahun" class="form-control form-control-sm" title="Tahun">
            @for($y = date('Y')-2; $y <= date('Y')+1; $y++)
                <option value="{{ $y }}" {{ $tahun == $y ? 'selected' : '' }}>{{ $y }}</option>
            @endfor
        </select>
    </div>-->
    <div class="col-auto">
        <input type="date" name="tanggal_awal" value="{{ $tanggal_awal }}" class="form-control form-control-sm" title="Tgl Awal">
    </div>
    <div class="col-auto">
        <input type="date" name="tanggal_akhir" value="{{ $tanggal_akhir }}" class="form-control form-control-sm" title="Tgl Akhir">
    </div>
    <div class="col-auto">
        <input type="text" name="search" value="{{ $search }}" class="form-control form-control-sm" placeholder="Cari nama">
    </div>
    <div class="col-auto">
        <button type="submit" class="btn btn-info btn-sm">Filter</button>
        <a href="{{ route('pt_purchases.index') }}" class="btn btn-secondary btn-sm">Reset</a>
    </div>
</form>
<table class="table table-bordered">
    <thead>
        <tr>
            <th>Tanggal</th>
            <th>Pembeli</th>
            <th>Paket/PT Visit</th>
            <th>Instruktur</th>
            <th>Harga</th>
            <th>Pembayaran</th>
            <th>Aksi</th>
        </tr>
    </thead>
    <tbody>
        @foreach($purchases as $trx)
        <tr>
            <td>{{ $trx->tanggal }}</td>
            <td>
                {{ $trx->member ? $trx->member->nama : ($trx->visitor ? $trx->visitor->nama : '-') }}
            </td>
            <td>{{ $trx->product->nama ?? '-' }}</td>
            <td>{{ $trx->instruktur->nama ?? '-' }}</td>
            <td>Rp {{ number_format($trx->harga) }}</td>
            <td>{{ ucfirst($trx->payment_method) }}</td>
            <td>
                <a href="{{ route('pt_purchases.print', $trx->id) }}" target="_blank" class="btn btn-xs btn-success"><i class="fas fa-print"></i>
                Cetak Struk</a>
                @if(auth()->user()->role == 'admin')
                || 
                    <form action="{{ route('pt_purchases.destroy', $trx->id) }}" method="POST" style="display:inline;" onsubmit="return confirm('Yakin hapus transaksi PT ini?')">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-xs btn-danger"><i class="fas fa-trash"></i> Hapus</button>
                    </form>
                @endif
            </td>
        </tr>
        @endforeach
    </tbody>
</table>
<strong>Total Transaksi ({{ $bulan }}/{{ $tahun }}{{ $tanggal_awal && $tanggal_akhir ? " | $tanggal_awal s/d $tanggal_akhir" : "" }}):</b>
    Rp {{ number_format($total) }}</strong>
<div class="mt-3">
    {{ $purchases->links() }}
</div>
@stop