@extends('adminlte::page')
@section('title', 'Tambah Transaksi PT')
@section('content_header')
    <h1>Tambah Transaksi PT</h1>
@stop
@section('content')
@if ($errors->any())
    <div class="alert alert-danger"><ul>@foreach ($errors->all() as $error) <li>{{ $error }}</li> @endforeach</ul></div>
@endif

<form method="POST" action="{{ route('pt_purchases.store') }}">
    @csrf

    <div class="form-group">
        <label>Pilih Pembeli</label>
        <select id="buyer_type" name="buyer_type" class="form-control" required>
            <option value="member">Member</option>
            <option value="visitor">Visitor</option>
        </select>
        <input type="text" id="buyer_search" class="form-control mt-2" placeholder="Cari nama..." autocomplete="off">
        <input type="hidden" name="buyer_id" id="buyer_id">
        <div id="buyer_suggestion" class="list-group mt-1"></div>
    </div>

    <div class="form-group">
        <label>Paket Latihan (Produk)</label>
        <select id="produk_id" name="produk_id" class="form-control" required>
            <option value="">- pilih produk -</option>
            @foreach($products as $p)
                <option value="{{ $p->id }}" data-harga="{{ $p->harga }}">{{ $p->nama }}</option>
            @endforeach
        </select>
    </div>

    <div class="form-group">
        <label>Pilih Instruktur</label>
        <select name="instruktur_id" class="form-control" required>
            <option value="">- pilih instruktur -</option>
            @foreach($instrukturs as $pt)
                <option value="{{ $pt->id }}">{{ $pt->nama }}</option>
            @endforeach
        </select>
    </div>
    <div class="form-group">
        <label>Tanggal Transaksi</label>
        <input type="date" name="tanggal" class="form-control" value="{{ date('Y-m-d') }}" required>
    </div>
    <div class="form-group">
        <label>Harga</label>
            <input type="text" name="harga_display" id="harga_display" class="form-control" readonly>
            <input type="hidden" name="harga" id="harga">
    </div>
    <div class="form-group">
        <label>Metode Pembayaran</label>
        <select name="payment_method" class="form-control" required>
            <option value="cash" selected>Cash</option>
            <option value="transfer">Transfer</option>
        </select>
    </div>
    <div class="form-group">
        <label>Pembayaran</label>
        <input type="number" name="bayar" id="bayar" class="form-control" min="0" required autocomplete="off" placeholder="Uang dibayar customer" required>
    </div>
    <div class="form-group">
        <label>Kembalian</label>
        <input type="text" id="kembalian_display" class="form-control" readonly>
        <input type="hidden" name="kembalian" id="kembalian">
    </div>
    <button type="submit" class="btn btn-primary btn-block">Simpan & Cetak Struk</button>
</form>

@push('js')
<script>
const members = @json($members);
const visitors = @json($visitors);

document.getElementById('buyer_search').addEventListener('input', function() {
    let type = document.getElementById('buyer_type').value;
    let keyword = this.value.toLowerCase();
    let data = type === 'member' ? members : visitors;
    let hasil = data.filter(item =>
        item.nama.toLowerCase().includes(keyword) ||
        (item.alamat && item.alamat.toLowerCase().includes(keyword))
    );
    let buyerSuggest = document.getElementById('buyer_suggestion');
    buyerSuggest.innerHTML = '';
    hasil.forEach(function(b) {
        let item = document.createElement('a');
        item.href = "#";
        item.className = "list-group-item list-group-item-action";
        item.innerHTML = `<b>${b.nama}</b> <span class="text-muted">(${b.alamat ?? '-'})</span>`;
        item.onclick = function() {
            document.getElementById('buyer_search').value = b.nama;
            document.getElementById('buyer_id').value = b.id;
            buyerSuggest.innerHTML = '';
            return false;
        };
        buyerSuggest.appendChild(item);
    });
});
document.getElementById('buyer_type').addEventListener('change', function() {
    document.getElementById('buyer_search').value = '';
    document.getElementById('buyer_id').value = '';
    document.getElementById('buyer_suggestion').innerHTML = '';
});

function formatRupiah(angka) {
    if(!angka) return '';
    return angka.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ".");
}

document.getElementById('produk_id').addEventListener('change', function() {
    let hargaRaw = this.selectedOptions[0].getAttribute('data-harga');
    let hargaInt = hargaRaw ? parseInt(hargaRaw) : '';
    document.getElementById('harga').value = hargaInt !== '' ? hargaInt : '';
    document.getElementById('harga_display').value = hargaInt !== '' ? formatRupiah(hargaInt) : '';
});

function hitungKembalian() {
    let bayar = parseInt(document.getElementById('bayar').value || "0");
    let harga = parseInt(document.getElementById('harga').value || "0");
    let kembalian = bayar - harga;
    document.getElementById('kembalian').value = kembalian > 0 ? kembalian : 0;
    document.getElementById('kembalian_display').value = kembalian > 0 ? formatRupiah(kembalian) : "0";
}

document.getElementById('bayar').addEventListener('input', hitungKembalian);
document.getElementById('produk_id').addEventListener('change', function() {
    // ... kode harga seperti sebelumnya ...
    let hargaRaw = this.selectedOptions[0].getAttribute('data-harga');
    let hargaInt = hargaRaw ? parseInt(hargaRaw) : '';
    document.getElementById('harga').value = hargaInt !== '' ? hargaInt : '';
    document.getElementById('harga_display').value = hargaInt !== '' ? formatRupiah(hargaInt) : '';
    hitungKembalian(); // update kembalian jika harga berubah
});

</script>
@endpush
@stop