@extends('adminlte::page')

@section('title', 'Detail Personal Trainer')

@section('content_header')
    <h1>Detail Personal Trainer</h1>
@stop

@section('content')
<div class="row">
    <!-- Data Diri -->
    <div class="col-md-4">
        <div class="card card-info">
            <div class="card-header">
                <h3 class="card-title">Profil PT</h3>
            </div>
            <div class="card-body">
                <strong>Nama:</strong> {{ $pt->nama }}<br>
                <strong>No. HP:</strong> {{ $pt->kontak }}<br>
                <strong>Keahlian:</strong> {{ $pt->keahlian }}<br>
                <strong>Status:</strong>
                <span class="badge badge-{{ $pt->status == 'aktif' ? 'success' : 'secondary' }}">{{ ucfirst($pt->status) }}</span><br>
                <strong>Dibuat:</strong> {{ $pt->created_at->format('d-m-Y H:i') }}
            </div>
        </div>

        <!-- Statistik -->
        <div class="card card-primary">
            <div class="card-header">
                <h3 class="card-title">Statistik</h3>
            </div>
            <div class="card-body">
                <ul class="list-group list-group-unbordered">
                    <li class="list-group-item">
                        <b>Sesi Bulan Ini</b>
                        <span class="float-right">{{ $pt->sesi_bulan_ini }}</span>
                    </li>
                    <li class="list-group-item">
                        <b>Visit Bulan Ini</b>
                        <span class="float-right">{{ $pt->visit_bulan_ini }}</span>
                    </li>
                    <li class="list-group-item">
                        <b>Total Sesi</b>
                        <span class="float-right">{{ $totalSesi }}</span>
                    </li>
                    <li class="list-group-item">
                        <b>Total Visit</b>
                        <span class="float-right">{{ $totalVisit }}</span>
                    </li>
                </ul>
            </div>
        </div>
    </div>

    <!-- Daftar Sesi -->
    <div class="col-md-8">
        <div class="card card-success">
            <div class="card-header">
                <h3 class="card-title">Daftar Sesi PT</h3>
            </div>
            <div class="card-body table-responsive p-0" style="max-height: 500px;">
                <table class="table table-hover text-nowrap">
                    <thead>
                        <tr>
                            <th>Tanggal & Waktu</th>
                            <th>Member</th>
                            <th>Status Kehadiran</th>
                            <th>Keterangan</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($sessions as $session)
                        <tr>
                            <td>{{ \Carbon\Carbon::parse($session->waktu)->format('d-m-Y H:i') }}</td>
                            <td>{{ $session->member->nama ?? '-' }}</td>
                            <td>
                                @if($session->ptVisits->count() > 0)
                                    <span class="badge badge-success">Hadir</span>
                                @else
                                    <span class="badge badge-warning">Belum Hadir</span>
                                @endif
                            </td>
                            <td>{{ $session->keterangan ?? '-' }}</td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="4" class="text-center">Belum ada sesi PT</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@stop