@extends('adminlte::page')

@section('title', 'Manajemen Personal Trainer')

@section('content_header')
    <h1>Manajemen Personal Trainer (PT)</h1>
@stop

@section('content')
<div class="card mb-3">
    <div class="card-body">
        <form method="GET" action="{{ route('pt.index') }}" class="row">
            <div class="col-md-3 mb-2">
                <input type="text" name="search" class="form-control" placeholder="Cari Nama PT atau Keahlian" value="{{ request('search') }}">
            </div>
            <div class="col-md-2 mb-2">
                <select name="status" class="form-control">
                    <option value="">Semua Status</option>
                    <option value="aktif" {{ request('status')=='aktif'?'selected':'' }}>Aktif</option>
                    <option value="nonaktif" {{ request('status')=='nonaktif'?'selected':'' }}>Nonaktif</option>
                </select>
            </div>
            <div class="col-md-2 mb-2">
                <input type="number" name="pt_sesi" class="form-control" min="0" placeholder="PT Sesi ≥" value="{{ request('pt_sesi') }}">
            </div>
            <div class="col-md-2 mb-2">
                <input type="number" name="pt_visit" class="form-control" min="0" placeholder="PT Visit ≥" value="{{ request('pt_visit') }}">
            </div>
            <div class="col-md-3 mb-2 text-right">
                <button type="submit" class="btn btn-sm btn-primary">Filter</button>
                <a href="{{ route('pt.index') }}" class="btn btn-default btn-sm ml-2">Reset</a>
                <a href="{{ route('pt.create') }}" class="btn btn-success btn-sm ml-2"><i class="fa fa-plus"></i> Tambah PT</a>
            </div>
        </form>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <h3 class="card-title">Daftar Personal Trainer</h3>
    </div>
    <div class="card-body table-responsive">
        <table class="table table-bordered table-hover">
            <thead class="thead-light">
                <tr>
                    <th>#</th>
                    <th>Nama PT</th>
                    <th>No. HP</th>
                    <th>Keahlian</th>
                    <th>Status</th>
                    <th>Sesi Bulan Ini</th>
                    <th>Visit Bulan Ini</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
                @forelse($pts as $i => $pt)
                    <tr>
                        <td>{{ $pts->firstItem() + $i }}</td>
                        <td>
                            <a href="{{ route('pt.show', $pt->id) }}">{{ $pt->nama }}</a>
                        </td>
                        <td>{{ $pt->kontak }}</td>
                        <td>{{ $pt->keahlian }}</td>
                        <td>
                            <span class="badge badge-{{ $pt->status=='aktif'?'success':'secondary' }}">
                                {{ ucfirst($pt->status) }}
                            </span>
                        </td>
                        <td>{{ $pt->sesi_bulan_ini }}</td>
                        <td>{{ $pt->visit_bulan_ini }}</td>
                        <td>
                            <a href="{{ route('pt.edit', $pt->id) }}" class="btn btn-sm btn-warning">
                                <i class="fa fa-edit"></i>
                            </a>
                            <form action="{{ route('pt.destroy', $pt->id) }}" method="POST" class="d-inline" onsubmit="return confirm('Hapus data PT?')">
                                @csrf
                                @method('DELETE')
                                <button class="btn btn-sm btn-danger">
                                    <i class="fa fa-trash"></i>
                                </button>
                            </form>
                            <a href="{{ route('pt.show', $pt->id) }}" class="btn btn-sm btn-info">
                                <i class="fa fa-info-circle"></i>
                            </a>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="8" class="text-center">Belum ada data PT.</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
        <div>
            {{ $pts->links() }}
        </div>
    </div>
</div>
@stop