@extends('adminlte::page')

@section('title', 'Edit Personal Trainer')

@section('content_header')
    <h1>Edit Personal Trainer</h1>
@stop

@section('content')
<div class="card">
    <div class="card-body">
        <form action="{{ route('pt.update', $pt->id) }}" method="POST">
            @csrf
            @method('PUT')
            <div class="form-group">
                <label>Nama</label>
                <input type="text" name="nama" class="form-control" required value="{{ old('nama', $pt->nama) }}">
            </div>
            <div class="form-group">
                <label>No. HP</label>
                <input type="text" name="kontak" class="form-control" value="{{ old('kontak', $pt->kontak) }}">
            </div>
            <div class="form-group">
                <label>Keahlian</label>
                <input type="text" name="keahlian" class="form-control" value="{{ old('keahlian', $pt->keahlian) }}">
            </div>
            <div class="form-group">
                <label>Status</label>
                <select name="status" class="form-control" required>
                    <option value="aktif" {{ old('status', $pt->status)=='aktif'?'selected':'' }}>Aktif</option>
                    <option value="nonaktif" {{ old('status', $pt->status)=='nonaktif'?'selected':'' }}>Nonaktif</option>
                </select>
            </div>
            <button type="submit" class="btn btn-primary">Update</button>
            <a href="{{ route('pt.index') }}" class="btn btn-secondary">Batal</a>
        </form>
    </div>
</div>
@stop