@extends('adminlte::page')

@section('title', 'Tambah Personal Trainer')

@section('content_header')
    <h1>Tambah Personal Trainer</h1>
@stop

@section('content')
<div class="card">
    <div class="card-body">
        <form action="{{ route('pt.store') }}" method="POST">
            @csrf
            <div class="form-group">
                <label>Nama</label>
                <input type="text" name="nama" class="form-control" required value="{{ old('nama') }}">
            </div>
            <div class="form-group">
                <label>No. HP</label>
                <input type="text" name="kontak" class="form-control" value="{{ old('kontak') }}">
            </div>
            <div class="form-group">
                <label>Keahlian</label>
                <input type="text" name="keahlian" class="form-control" value="{{ old('keahlian') }}">
            </div>
            <div class="form-group">
                <label>Status</label>
                <select name="status" class="form-control" required>
                    <option value="aktif" {{ old('status')=='aktif'?'selected':'' }}>Aktif</option>
                    <option value="nonaktif" {{ old('status')=='nonaktif'?'selected':'' }}>Nonaktif</option>
                </select>
            </div>
            <button type="submit" class="btn btn-success">Simpan</button>
            <a href="{{ route('pt.index') }}" class="btn btn-secondary">Batal</a>
        </form>
    </div>
</div>
@stop