@extends('adminlte::page')

@section('title', 'Produk')

@section('content_header')
    <h1>Kelola Produk</h1>
@stop

@section('content')
@if(session('success'))
    <div class="alert alert-success">{{ session('success') }}</div>
@endif

<form method="GET" action="{{ route('produk.index') }}" class="form-inline mb-3">
    <input type="text" name="q" class="form-control mr-2" value="{{ $q ?? '' }}" placeholder="Cari nama/kategori produk">
    <button class="btn btn-primary" type="submit">Cari</button>
    @if($q)
        <a href="{{ route('produk.index') }}" class="btn btn-default ml-2">Reset</a>
    @endif
    <a href="{{ route('produk.create') }}" class="btn btn-success ml-auto">Tambah Produk</a>
</form>

<div class="table-responsive">
    <table class="table table-bordered table-striped">
        <thead>
            <tr>
                <th>#</th>
                <th>Nama Produk</th>
                <th>Kategori</th>
                <th>Stok</th>
                <th>Harga</th>
                <th>Aksi</th>
            </tr>
        </thead>
        <tbody>
            @forelse($products as $i => $p)
                <tr>
                    <td>{{ $products->firstItem() + $i }}</td>
                    <td>{{ $p->nama }}</td>
                    <td>{{ ucfirst(str_replace('_',' ', $p->kategori)) }}</td>
                    <td>{{ $p->stok }}</td>
                    <td>{{ number_format($p->harga,0,',','.') }}</td>
                    <td>
                        <form action="{{ route('produk.restok', $p) }}" method="POST" class="d-inline">
                            @csrf
                            <input type="number" name="jumlah" min="1" class="form-control d-inline" style="width: 80px;" required>
                            <button type="submit" class="btn btn-success btn-sm">Restok</button>
                        </form>
                        <a href="{{ route('produk.edit', $p) }}" class="btn btn-warning btn-sm">Edit</a>
                        @if(auth()->user()->role == 'admin')
                        <form method="POST" action="{{ route('produk.destroy', $p) }}" style="display:inline" onsubmit="return confirm('Hapus produk ini?')">
                            @csrf @method('DELETE')
                            <button class="btn btn-danger btn-sm" type="submit">Hapus</button>
                        </form>
                        @endif
                    </td>
                </tr>
            @empty
                <tr><td colspan="6" class="text-center">Belum ada produk</td></tr>
            @endforelse
        </tbody>
    </table>
    {{ $products->links() }}
</div>
@stop