@extends('adminlte::page')
@section('title', 'Edit Produk')
@section('content_header')
    <h1>Edit Produk</h1>
@stop
@section('content')

<form method="POST" action="{{ route('produk.update', $product) }}">
    @csrf @method('PUT')
    <div class="form-group">
        <label>Nama Produk</label>
        <input type="text" name="nama" class="form-control" required value="{{ $product->nama }}">
    </div>
    <div class="form-group">
        <label>Kategori</label>
        <select name="kategori" class="form-control" required>
            @foreach($kategori as $val => $label)
                <option value="{{ $val }}" {{ $product->kategori == $val ? 'selected' : '' }}>{{ $label }}</option>
            @endforeach
        </select>
    </div>
    <div class="form-group">
        <label>Stok</label>
        <input type="number" name="stok" class="form-control" required min="0" value="{{ $product->stok }}">
    </div>
    <div class="form-group">
        <label>Harga</label>
        <input type="number" name="harga" class="form-control" required min="0" value="{{ $product->harga }}">
    </div>
    <button type="submit" class="btn btn-primary">Update</button>
    <a href="{{ route('produk.index') }}" class="btn btn-secondary">Batal</a>
</form>
@stop