@extends('adminlte::page')
@section('title', 'Tambah Produk')
@section('content_header')
    <h1>Tambah Produk</h1>
@stop
@section('content')
<form method="POST" action="{{ route('produk.store') }}">
    @csrf
    <div class="form-group">
        <label>Nama Produk</label>
        <input type="text" name="nama" class="form-control" required>
    </div>
    <div class="form-group">
        <label>Kategori</label>
        <select name="kategori" class="form-control" required>
            @foreach($kategori as $val => $label)
                <option value="{{ $val }}">{{ $label }}</option>
            @endforeach
        </select>
    </div>
    <div class="form-group">
        <label>Stok</label>
        <input type="number" name="stok" class="form-control" required min="0" value="0">
    </div>
    <div class="form-group">
        <label>Harga</label>
        <input type="number" name="harga" class="form-control" required min="0" value="0">
    </div>
    <button type="submit" class="btn btn-primary">Simpan</button>
    <a href="{{ route('produk.index') }}" class="btn btn-secondary">Batal</a>
</form>
@stop