@extends('adminlte::page')

@section('title', 'Detail Member')

@section('content_header')
    <h1>Detail Member</h1>
@stop

@section('content')
<div class="card">
    <div class="card-header">
        <strong>{{ $member->nama }}</strong>
    </div>
    <div class="card-body">
        <p><b>Kontak:</b> {{ $member->kontak }}</p>
        <p><b>Alamat:</b> {{ $member->alamat }}</p>
        <p><b>Expired At:</b> {{ $member->expired_at }}</p>
        <p><b>Status:</b>
            @if($member->is_active)
                <span class="badge bg-success">Aktif</span>
            @else
                <span class="badge bg-danger">Nonaktif</span>
            @endif
        </p>
    </div>
    <div class="card-footer">
        <a href="{{ route('members.edit', $member->id) }}" class="btn btn-warning">Edit</a>
        <a href="{{ route('members.index') }}" class="btn btn-secondary">Kembali</a>
    </div>
</div>
@endsection
