@extends('adminlte::page')

@section('title', 'Daftar Member')

@section('content_header')
    <h1>Daftar Member</h1>
@stop
@section('css')
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css"/>
@endsection

@section('js')
<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
<script>
    $(document).ready(function() {
      $('.table').DataTable({
        "ordering": true,
        "order": [],
        "paging": false, // kalau sudah pakai paginasi laravel, matikan ini
        "info": false,
        "searching": false // sudah ada form cari manual
      });
    });
</script>
@endsection
@section('content')
@if(session('success'))
    <div class="alert alert-success">{{ session('success') }}</div>
@endif
<div class="d-flex justify-content-between align-items-center mb-3">
    <a href="{{ route('members.create') }}" class="btn btn-success btn-sm">
        <i class="fas fa-plus"></i> Tambah Member
    </a>
    <form method="GET" action="{{ route('members.index') }}" class="d-flex" style="max-width:190px;">
        <div class="input-group input-group-sm">
            <input type="text" name="q" value="{{ $search ?? '' }}" class="form-control" placeholder="Cari...">
            <button class="btn btn-primary btn-sm" type="submit">
                <i class="fas fa-search"></i>
            </button>
        </div>
    </form>
</div>
<table class="table table-sm table-bordered table-hover">
    <thead>
        <tr>
            <th>No.</th> {{-- Tambahkan kolom ini --}}
            <th>Nama</th>
            <th>Kontak</th>
            <th>Alamat</th>
            <th>Expired</th>
            <th>Status</th>
            <th style="width:200px;">Aksi</th>
            <th style="width:80px;">Hapus</th>
        </tr>
    </thead>
    <tbody>
        @foreach($members as $member)
        <tr>
            <td>{{ $loop->iteration }}</td> {{-- Tambahkan baris ini --}}
            <td>{{ $member->nama }}</td>
            <td>{{ $member->kontak }}</td>
            <td>{{ $member->alamat }}</td>
            <td>{{ $member->expired_at }}</td>
            
            <td>
                @if($member->is_active && $member->expired_at && \Carbon\Carbon::parse($member->expired_at)->isFuture())
                   <span class="badge bg-success">Aktif</span>
                @else
                    <span class="badge bg-danger">Nonaktif</span>
                @endif
            </td>
            <td>
                <a href="{{ route('members.card', $member->id) }}" target="_blank" class="btn btn-info btn-xs">Cetak</a>
                <a href="{{ route('members.show', $member->id) }}" class="btn btn-info btn-xs">Detail</a>
                <a href="{{ route('members.edit', $member->id) }}" class="btn btn-warning btn-xs">Edit</a>
            </td>
            <td> @if(auth()->user()->role == 'admin')
            <form action="{{ route('members.destroy', $member->id) }}" method="POST" style="display:inline;">
                    @csrf @method('DELETE')
                    <button type="submit" class="btn btn-danger btn-xs"
                        onclick="return confirm('Yakin hapus?')">Hapus</button>
                </form>
                @endif
            </td>
        </tr>
        @endforeach
    </tbody>
</table>
<div>
    {{ $members->links() }}
</div>
@endsection