@extends('layouts.app')

@section('content')
<div class="container">
    <h2>Daftar Member</h2>
    <div class="mb-3">
        <input type="text" id="search" class="form-control" placeholder="Cari Nama / Alamat / Kontak...">
    </div>

    <div id="member-list">
        @include('members.partials.list', ['members' => $members])
    </div>
</div>
@endsection

@push('scripts')
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(function(){
    $('#search').on('keyup', function() {
        let q = $(this).val();
        $.get("{{ route('members.live_search') }}", {q: q}, function(data){
            $('#member-list').html(data);
        });
    });
});
</script>
@endpush