@extends('adminlte::page')
@section('title', 'Detail Instruktur')
@section('content_header')
    <h1>Detail Instruktur: {{ $instruktur->nama }}</h1>
@stop
@section('content')
<div class="mb-3">
    <a href="{{ route('instrukturs.index') }}" class="btn btn-secondary mb-2">Kembali ke Daftar</a>
    <a href="{{ route('instrukturs.edit', $instruktur->id) }}" class="btn btn-warning mb-2">Edit Instruktur</a>
</div>
<div class="card mb-3">
    <div class="card-header">Profil Instruktur</div>
    <div class="card-body">
        <p><b>Nama:</b> {{ $instruktur->nama }}</p>
        <p><b>Kontak:</b> {{ $instruktur->kontak }}</p>
        <p><b>Alamat:</b> {{ $instruktur->alamat }}</p>
    </div>
</div>
<div class="card">
    <div class="card-header">Riwayat Membimbing</div>
    <div class="card-body p-0">
        <table class="table table-striped m-0">
            <thead>
                <tr>
                    <th>Tanggal</th>
                    <th>Jenis</th>
                    <th>Nama Member/Visitor</th>
                    <th>Paket/Produk</th>
                    <th>Harga</th>
                </tr>
            </thead>
            <tbody>
                @forelse($riwayat as $trx)
                <tr>
                    <td>{{ $trx->tanggal }}</td>
                    <td>{{ $trx->product->kategori == 'pt_sesi' ? 'PT Sesi' : 'PT Visit' }}</td>
                    <td>{{ $trx->member ? $trx->member->nama : ($trx->visitor ? $trx->visitor->nama : '-') }}</td>
                    <td>{{ $trx->product->nama }}</td>
                    <td>Rp {{ number_format($trx->harga) }}</td>
                </tr>
                @empty
                <tr>
                    <td colspan="5" class="text-center">Belum ada riwayat membimbing.</td>
                </tr>
                @endforelse
            </tbody>
        </table>
        <div class="mt-3 px-3">
            {{ $riwayat->links() }}
        </div>
    </div>
</div>
@stop