@extends('adminlte::page')
@section('title', 'Daftar Personal Trainer')
@section('content_header')
    <h1>Daftar Personal Trainer</h1>
@stop
@section('content')
<a href="{{ route('instrukturs.create') }}" class="btn btn-sm btn-primary mb-3"><i class="fas fa-plus"></i>Tambah PT</a>
@if(session('success'))
    <div class="alert alert-success">{{ session('success') }}</div>
@endif
<table class="table table-bordered">
    <thead>
        <tr>
            <th>Nama</th>
            <th>Kontak</th>
            <th>Alamat</th>
            <th>Aksi</th>
        </tr>
    </thead>
    <tbody>
        @foreach($instrukturs as $pt)
        <tr>
            <td><a href="{{ route('instrukturs.show', $pt->id) }}">{{ $pt->nama }}</a></td>
            <td>{{ $pt->kontak }}</td>
            <td>{{ $pt->alamat }}</td>
            <td>
                <a href="{{ route('instrukturs.edit', $pt->id) }}" class="btn btn-warning btn-sm">Edit</a>
                || @if(auth()->user()->role == 'admin')
                <form action="{{ route('instrukturs.destroy', $pt->id) }}" method="POST" class="d-inline" onsubmit="return confirm('Yakin hapus?')">
                    @csrf @method('DELETE')
                    <button class="btn btn-danger btn-sm">Hapus</button>
                </form>
                @endif
            </td>
        </tr>
        @endforeach
    </tbody>
</table>

<div class="mt-3">
    {{ $instrukturs->links() }}
</div>
@stop