@extends('adminlte::page')

@section('title', 'Dashboard Pendapatan')

@section('content')
<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>
        Dashboard Pendapatan       
    </h1>
    <br><h5>Rekap Harian dan Bulanan</h5>
</section>

<!-- Main content -->
<section class="content">

<div class="row">
    <!-- Pendapatan Visit Hari & Bulan -->
    <div class="col-md-6 col-sm-6 col-12">
    <a href="{{ route('visitor_attendance.rekap') }}" class="text-decoration-none">
        <div class="info-box bg-info">
            <span class="info-box-icon"><i class="fas fa-door-open"></i></span>
            <div class="info-box-content">
                <span class="info-box-text">Pendapatan Visit</span>
                <span class="info-box-number"> Rp {{ number_format($daily['visit'],0,',','.') }}</span>
                <div class="progress">
                    <div class="progress-bar" style="width: 100%"></div>
                </div>
                <span class="progress-description">
                    <b>Rp {{ number_format($monthly['visit'],0,',','.') }}</b>
                </span>
            </div>
        </div>
    </a>
    </div>
    <!-- Pendapatan Produk -->
    <div class="col-md-6 col-sm-6 col-12">
    <a href="{{ route('purchases.index') }}" class="text-decoration-none">
        <div class="info-box bg-success">
            <span class="info-box-icon"><i class="fas fa-cubes"></i></span>
            <div class="info-box-content">
                <span class="info-box-text">Pendapatan Produk</span>
                <span class="info-box-number"> Rp {{ number_format($daily['produk'],0,',','.') }}</span>
                <div class="progress">
                    <div class="progress-bar" style="width: 100%"></div>
                </div>
                <span class="progress-description">
                    <b> Rp {{ number_format($monthly['produk'],0,',','.') }}</b>
                </span>
            </div>
        </div>
    </a>
    </div>
    <!-- Pendapatan Member Card -->
    <div class="col-md-6 col-sm-6 col-12">
    @php
    $startMonth = \Carbon\Carbon::now()->startOfMonth()->format('Y-m-d');
    $endMonth = \Carbon\Carbon::now()->endOfMonth()->format('Y-m-d');
    $memberCardUrl = route('purchases.index') . "?tanggal_mulai={$startMonth}&tanggal_selesai={$endMonth}&q=member+card";
    @endphp

    <a href="{{ $memberCardUrl }}" class="text-decoration-none">
        <div class="info-box bg-warning">
            <span class="info-box-icon"><i class="fas fa-id-card"></i></span>
            <div class="info-box-content">
                <span class="info-box-text">Pendapatan Member Card</span>
                <span class="info-box-number"> Rp {{ number_format($daily['member_card'],0,',','.') }}</span>
                <div class="progress">
                    <div class="progress-bar" style="width: 100%"></div>
                </div>
                <span class="progress-description">
                    <b> Rp {{ number_format($monthly['member_card'],0,',','.') }}</b>
                </span>
            </div>
        </div>
    </a>
    </div>
    <!-- Pendapatan PT -->
    <div class="col-md-6 col-sm-6 col-12">
    <a href="{{ route('pt_purchases.index') }}" class="text-decoration-none">
        <div class="info-box bg-danger">
            <span class="info-box-icon"><i class="fas fa-dumbbell"></i></span>
            <div class="info-box-content">
                <span class="info-box-text">Pendapatan PT</span>
                <span class="info-box-number"> Rp {{ number_format($daily['pt'],0,',','.') }}</span>
                <div class="progress">
                    <div class="progress-bar" style="width: 100%"></div>
                </div>
                <span class="progress-description">
                    <b> Rp {{ number_format($monthly['pt'],0,',','.') }}</b>
                </span>
            </div>
        </div>
    </a>
    </div>
</div>

<div class="row">
  <!-- Card Rekap Member  -->
  <div class="col-md-6 col-sm-6 col-12">
  <a href="{{ route('members.index') }}" class="text-decoration-none">
        <div class="info-box bg-secondary">
            <span class="info-box-icon"><i class="fas fa-fw fa-users"></i></span>
            <div class="info-box-content">
                <span class="info-box-text">Member Status</span>
                <span class="info-box-number"> Expired : {{ $members->where('expired_at', '<', now())->count() }}</span>
                <div class="progress">
                    <div class="progress-bar" style="width: 100%"></div>
                </div>
                <span class="progress-description">
                    <b>Aktif : {{ $members->where('expired_at', '>', now())->count() }}</b>
                </span>
            </div>
        </div>
    </a>
    </div>
  </div>

{{-- Jika ingin ada tabel rekap, bisa tambahkan di bawah ini --}}

</section>
@endsection