@extends('adminlte::page')

@section('title', 'Rekap Absensi')

@section('content_header')
    <h1>Rekap Absensi Member</h1>
@stop

@section('content')
<div class="mb-3">
    <form method="GET" action="{{ url('/absensi/rekap') }}" class="form-inline">
        <div class="input-group mb-2 mr-sm-2">
            <input type="text" name="search" class="form-control" placeholder="Cari nama member" value="{{ request('search') }}">
        </div>
        <div class="input-group mb-2 mr-sm-2">
            <select name="filter" class="form-control">
                <!--<option value="">-- Semua Data --</option>-->
                <option value="harian" {{ request('filter') == 'harian' ? 'selected' : '' }}>Harian</option>
                <option value="mingguan" {{ request('filter') == 'mingguan' ? 'selected' : '' }}>Mingguan</option>
                <option value="bulanan" {{ request('filter') == 'bulanan' ? 'selected' : '' }}>Bulanan</option>
                <option value="tahunan" {{ request('filter') == 'tahunan' ? 'selected' : '' }}>Tahunan</option>
            </select>
        </div>
        <button type="submit" class="btn btn-primary mb-2">Terapkan</button>
        @if(request('filter') || request('search'))
            <a href="{{ url('/absensi/rekap') }}" class="btn btn-default mb-2 ml-2">Reset</a>
        @endif
    </form>
</div>
<div class="table-responsive">
    <table class="table table-bordered table-striped mt-3">
        <thead>
            <tr>
                <th>#</th>
                <th>Tanggal & Jam Scan</th>
                <th>Nama Member</th>
                <!-- <th>ID Member</th>
                <th>Keterangan</th> -->
            </tr>
        </thead>
        <tbody>
            @forelse($absensi as $i => $absen)
                <tr>
                    <td>{{ $absensi->firstItem() + $i }}</td>
                    <td>{{ \Carbon\Carbon::parse($absen->waktu_scan)->format('d-m-Y H:i:s') }}</td>
                    <td>{{ $absen->member ? $absen->member->nama : '-' }}</td>
                    <!-- <td>{{ $absen->member_id }}</td>
                    <td>{{ $absen->keterangan ?? '-' }}</td> -->
                </tr>
            @empty
                <tr>
                    <td colspan="5" class="text-center">Belum ada data absensi.</td>
                </tr>
            @endforelse
        </tbody>
    </table>
</div>
<div>
    {{ $absensi->links() }}
</div>
@stop