<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

//class CreatePtPurchasesTable extends Migration
class CreatePtPurchasesTable extends Migration
{
    public function up()
    {
        Schema::create('pt_purchases', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('member_id')->nullable();
            $table->unsignedBigInteger('visitor_id')->nullable();
            $table->unsignedBigInteger('produk_id');
            $table->unsignedBigInteger('instruktur_id')->nullable();
            $table->date('tanggal');
            $table->integer('harga');
            $table->string('payment_method', 20)->nullable();
            $table->timestamps();

            $table->foreign('member_id')->references('id')->on('members')->nullOnDelete();
            $table->foreign('visitor_id')->references('id')->on('visitors')->nullOnDelete();
            $table->foreign('produk_id')->references('id')->on('products')->cascadeOnDelete();
            $table->foreign('instruktur_id')->references('id')->on('instrukturs')->nullOnDelete();
        });
    }

    public function down()
    {
        Schema::dropIfExists('pt_purchases');
    }
}