<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateGymTables extends Migration
{
    public function up()
    {
        // Members Table
        Schema::create('members', function (Blueprint $table) {
            $table->id();
            $table->string('nama');
            $table->string('kontak');
            $table->string('alamat');
            $table->string('qr_code')->nullable();
            $table->date('expired_at')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });

        // Absence Table
        Schema::create('absences', function (Blueprint $table) {
            $table->id();
            $table->foreignId('member_id')->constrained('members')->onDelete('cascade');
            $table->dateTime('waktu_scan');
            $table->string('keterangan')->nullable();
            $table->timestamps();
        });

        // Products Table
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->string('nama');
            $table->enum('kategori', ['air_minum', 'suplement', 'snack', 'merchandise']);
            $table->integer('stok')->default(0);
            $table->decimal('harga', 12, 2);
            $table->timestamps();
        });

        // Purchases Table
        Schema::create('purchases', function (Blueprint $table) {
            $table->id();
            //$table->foreignId('member_id')->constrained('members')->onDelete('cascade');
            // di migration purchases table
            $table->foreignId('member_id')->nullable()->constrained('members')->onDelete('cascade');
            $table->dateTime('tanggal');
            $table->decimal('total_harga', 12, 2);
            // Tambahkan kolom di purchases table
            $table->string('nama_pembeli')->nullable();
            $table->timestamps();
        });

        // Purchase Details Table (item by item)
        Schema::create('purchase_details', function (Blueprint $table) {
            $table->id();
            $table->foreignId('purchase_id')->constrained('purchases')->onDelete('cascade');
            $table->foreignId('product_id')->constrained('products')->onDelete('cascade');
            $table->integer('qty');
            $table->decimal('harga_satuan', 12, 2);
            $table->timestamps();
        });

        // Personal Trainers Table
        Schema::create('personal_trainers', function (Blueprint $table) {
            $table->id();
            $table->string('nama');
            $table->string('kontak');
            $table->timestamps();
        });

        // PT Sessions Table
        Schema::create('pt_sessions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('member_id')->constrained('members')->onDelete('cascade');
            $table->foreignId('personal_trainer_id')->constrained('personal_trainers')->onDelete('cascade');
            $table->dateTime('waktu');
            $table->string('keterangan')->nullable();
            $table->timestamps();
        });

        // PT Visits Table
        Schema::create('pt_visits', function (Blueprint $table) {
            $table->id();
            $table->foreignId('pt_session_id')->constrained('pt_sessions')->onDelete('cascade');
            $table->dateTime('waktu_hadir');
            $table->timestamps();
        });

        // Notifications Table (optional)
        Schema::create('notifications', function (Blueprint $table) {
            $table->id();
            $table->foreignId('member_id')->constrained('members')->onDelete('cascade');
            $table->string('jenis'); // misal: 'perpanjangan'
            $table->text('konten');
            $table->boolean('dibaca')->default(false);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('notifications');
        Schema::dropIfExists('pt_visits');
        Schema::dropIfExists('pt_sessions');
        Schema::dropIfExists('personal_trainers');
        Schema::dropIfExists('purchase_details');
        Schema::dropIfExists('purchases');
        Schema::dropIfExists('products');
        Schema::dropIfExists('absences');
        Schema::dropIfExists('members');
    }
}
