<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Purchase extends Model
{
    use HasFactory;

    protected $fillable = [
        'member_id',
        'nama_pembeli',
        'alamat_pembeli',
        'tanggal',
        'total_harga',
        'bayar',      
        'kembali',
        'payment_method',    
    ];

    public function member() {
        return $this->belongsTo(Member::class, 'member_id');
    }

    public function details()
    {
        return $this->hasMany(PurchaseDetail::class);
    }
}
