<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PtPurchase extends Model
{
    use HasFactory;

    protected $fillable = [
        'member_id', 'visitor_id', 'produk_id', 'instruktur_id',
        'tanggal', 'harga', 'payment_method','bayar','kembalian'
    ];

    public function member()
    {
        return $this->belongsTo(Member::class);
    }

    public function visitor()
    {
        return $this->belongsTo(Visitor::class);
    }

    public function product()
    {
        return $this->belongsTo(Product::class, 'produk_id');
    }

    public function instruktur()
    {
        return $this->belongsTo(Instruktur::class);
    }
}