<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class PersonalTrainer extends Model
{
    protected $table = 'personal_trainers';
    protected $fillable = [
        'nama', 'kontak', 'keahlian', 'status'
    ];

    public function sesi()
    {
        return $this->hasMany(PTSession::class);
    }

    // Relasi visit harus pakai hasManyThrough
    public function visits()
    {
        return $this->hasManyThrough(
            PTVisit::class,       // Model tujuan
            PTSession::class,     // Model perantara
            'personal_trainer_id',// Foreign key di pt_sessions
            'pt_session_id',      // Foreign key di pt_visits
            'id',                 // Local key di personal_trainers
            'id'                  // Local key di pt_sessions
        );
    }

    // Akses jumlah sesi bulan ini
    public function getSesiBulanIniAttribute()
    {
        return $this->sesi()->whereMonth('waktu', now()->month)
            ->whereYear('waktu', now()->year)->count();
    }

    // Akses jumlah visit bulan ini
    public function getVisitBulanIniAttribute()
    {
        return $this->visits()
            ->whereMonth('waktu_hadir', now()->month)
            ->whereYear('waktu_hadir', now()->year)
            ->count();
    }
}