<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class PTSession extends Model
{
    use HasFactory;
    protected $table = 'pt_sessions';

    protected $fillable = [
        'member_id', 'personal_trainer_id', 'waktu', 'keterangan'
    ];

    public function member()
    {
        return $this->belongsTo(Member::class);
    }

    public function personalTrainer()
    {
        return $this->belongsTo(PersonalTrainer::class);
    }

    public function ptVisits()
    {
        return $this->hasMany(PTVisit::class, 'pt_session_id');
    }
}
