<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Member extends Model
{
    use HasFactory;

    protected $fillable = [
        'nama', 'kontak', 'alamat', 'qr_code', 'expired_at', 'is_active'
    ];

    public function absences()
    {
        return $this->hasMany(Absence::class);
    }

    public function purchases()
    {
        return $this->hasMany(Purchase::class);
    }

    public function ptSessions()
    {
        return $this->hasMany(PTSession::class);
    }

    public function notifications()
    {
        return $this->hasMany(Notification::class);
    }
}
