<?php

namespace App\Http\Controllers;

use App\Models\Visitor;
use App\Models\Member;
use Illuminate\Http\Request;
use App\Models\Product;
use App\Models\Instruktur;

class VisitorController extends Controller
{
    public function index()
    {
        $visitors = Visitor::paginate(10);
    
        // Dapatkan harga visit_only dari tabel products
        $visit_only_product = Product::where('nama', 'visit_only')->first();
        $visit_only_price = $visit_only_product ? $visit_only_product->harga : 0;
    
        // Dapatkan produk PT dari tabel products dengan kategori pt_visit
        //$pt_products = Product::where('kategori', 'pt_visit')->get();
        $pt_products =Product::whereIn('kategori', ['pt_visit', 'pt_sesi'])->get();
    
        // Dapatkan list instruktur (ganti jika nama modelnya berbeda)
        $instructors = Instruktur::all();
    
        return view('visitor.index', compact(
            'visitors',
            'visit_only_price',
            'pt_products',
            'instructors'
        ));
    }
    public function create()
    {
        return view('visitor.create');
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'nama' => 'required|string|max:255',
            'alamat' => 'nullable|string|max:255',
            'kontak' => 'nullable|string|max:50',
        ]);
        Visitor::create($data);
        return redirect()->route('visitor.index')->with('success', 'Data visitor berhasil ditambahkan!');
    }

    public function toMember($id)
    {
        $visitor = Visitor::findOrFail($id);
        // Expire at default kemarin
        $expire_at = now()->subDay()->format('Y-m-d');
        return view('visitor.to-member', compact('visitor', 'expire_at'));
    }

    public function storeMember(Request $request, $id)
    {
        $visitor = Visitor::findOrFail($id);

        $data = $request->validate([
            'expire_at' => 'required|date',
        ]);
        // Copy data visitor ke member
        Member::create([
            'nama' => $visitor->nama,
            'alamat' => $visitor->alamat,
            'kontak' => $visitor->kontak,
            'expired_at' => $data['expire_at'],
            // Tambahkan field lain sesuai kebutuhan member
        ]);
        $visitor->delete();
        return redirect()->route('members.index')->with('success', 'Visitor berhasil menjadi member!');
    }

    public function edit($id)
    {
        $visitor = Visitor::findOrFail($id);
        return view('visitor.edit', compact('visitor'));
    }

    public function update(Request $request, $id)
    {
        $visitor = Visitor::findOrFail($id);
        $request->validate([
            'nama' => 'required|string|max:255',
            'alamat' => 'required|string|max:255',
            'kontak' => 'nullable|string|max:50',
        ]);
        $visitor->update($request->only(['nama', 'alamat', 'kontak']));
        return redirect()->route('visitor.index')->with('success', 'Data visitor berhasil diupdate!');
    }
    
    public function destroy($id)
    {
        if (auth()->user()->role !== 'admin') {
            abort(403, 'Unauthorized action.');
        }        
        $visitor = Visitor::findOrFail($id);
        $visitor->delete();
        return redirect()->route('visitor.index')->with('success', 'Visitor berhasil dihapus.');
    }
    
}