<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\PersonalTrainer;
use Illuminate\Support\Facades\DB;

class PersonalTrainerController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    
    public function index(Request $request)
    {
               
        $bulan = now()->month;
        $tahun = now()->year;
        $perPage = 15;

        // Subquery sesi bulan ini
        $sesiSub = DB::table('pt_sessions')
            ->selectRaw('COUNT(*)')
            ->whereRaw('pt_sessions.personal_trainer_id = personal_trainers.id')
            ->whereMonth('waktu', $bulan)
            ->whereYear('waktu', $tahun);
        
        // Subquery visit bulan ini TANPA JOIN
        $visitSub = DB::table('pt_visits')
        ->whereIn('pt_session_id', function($query) use ($bulan, $tahun) {
            $query->select('id')
                ->from('pt_sessions')
                ->whereRaw('pt_sessions.personal_trainer_id = personal_trainers.id');
        })
            ->whereMonth('waktu_hadir', $bulan)
            ->whereYear('waktu_hadir', $tahun)
            ->selectRaw('COUNT(id)');

        $query = PersonalTrainer::query()
            ->select('personal_trainers.*')
            ->selectSub($sesiSub, 'sesi_bulan_ini')
            ->selectSub($visitSub, 'visit_bulan_ini');

        // Filter search
        if ($request->filled('search')) {
            $query->where(function($q) use ($request) {
                $q->where('nama', 'like', '%'.$request->search.'%')
                  ->orWhere('keahlian', 'like', '%'.$request->search.'%');
            });
        }
        // Filter status
        if ($request->filled('status')) {
            $query->where('status', $request->status);
        }
        // Filter jumlah sesi
        if ($request->filled('pt_sesi')) {
            $query->having('sesi_bulan_ini', '>=', $request->pt_sesi);
        }
        // Filter jumlah visit
        if ($request->filled('pt_visit')) {
            $query->having('visit_bulan_ini', '>=', $request->pt_visit);
        }

        $pts = $query->paginate($perPage)->appends($request->query());
        //dd($pts->toArray());

        return view('pt.index', compact('pts'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('pt.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $data = $request->validate([
            'nama' => 'required|string|max:255',
            'kontak' => 'nullable|string|max:20',
            'keahlian' => 'nullable|string|max:100',
            'status' => 'required|in:aktif,nonaktif',
        ]);
        PersonalTrainer::create($data);
        return redirect()->route('pt.index')->with('success', 'Data PT berhasil ditambahkan!');
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        $pt = PersonalTrainer::findOrFail($id);
        return view('pt.edit', compact('pt'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        $pt = PersonalTrainer::findOrFail($id);
        $data = $request->validate([
            'nama' => 'required|string|max:255',
            'kontak' => 'nullable|string|max:20',
            'keahlian' => 'nullable|string|max:100',
            'status' => 'required|in:aktif,nonaktif',
        ]);
        $pt->update($data);
        return redirect()->route('pt.index')->with('success', 'Data PT berhasil diupdate!');
    }

    public function show($id) {
        // Sementara, cukup return string saja dulu
        //return "Show Personal Trainer $id";
        
            $pt = PersonalTrainer::findOrFail($id);
            // Total sesi dan visit
           
            $totalSesi = $pt->sesi()->count();
            $totalVisit = $pt->visits()->count();
            // Daftar sesi (bisa paginasi kalau mau)
            $sessions = $pt->sesi()->with('member', 'ptVisits')->orderBy('waktu', 'desc')->get();
            //dd($sessions->toArray());
            return view('pt.show', compact('pt', 'sessions', 'totalSesi', 'totalVisit'));
        
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $pt = PersonalTrainer::findOrFail($id);
        $pt->delete();
        return redirect()->route('pt.index')->with('success', 'Data PT berhasil dihapus!');
    }
}