<?php

namespace App\Http\Controllers;

use App\Models\Member;
use Illuminate\Http\Request;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use Barryvdh\DomPDF\Facade\Pdf;

class MemberController extends Controller
{
    public function index(Request $request)
    {
        $search = $request->input('q');

        $query = Member::query();
         if ($search) {
             $query->where(function($q) use ($search) {
                $q->where('nama', 'like', "%$search%")
                  ->orWhere('alamat', 'like', "%$search%")
                  ->orWhere('kontak', 'like', "%$search%");
            });
        }

        $members = $query->orderBy('created_at', 'desc')->paginate(15);

        return view('members.index', compact('members', 'search'));
    }

    public function create()
    {
        return view('members.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'nama' => 'required|string|max:100',
            'kontak' => 'required|string|max:50',
            'alamat' => 'required|string|max:255',
            'expired_at' => 'nullable|date',
        ]);

        Member::create($request->all());

        //return redirect()->route('members.index')->with('success', 'Member berhasil ditambahkan.');
        return redirect()->route('purchases.create')->with('success', 'Member berhasil ditambahkan.');
    }

    public function show(Member $member)
    {
        return view('members.show', compact('member'));
    }

    public function edit(Member $member)
    {
        return view('members.edit', compact('member'));
    }

    public function update(Request $request, Member $member)
    {
        $request->validate([
            'nama' => 'required|string|max:100',
            'kontak' => 'required|string|max:50',
            'alamat' => 'required|string|max:255',
            'expired_at' => 'nullable|date',
        ]);

        $member->update($request->all());

        return redirect()->route('members.index')->with('success', 'Member berhasil diupdate.');
    }

    public function destroy(Member $member)
    {
        if (auth()->user()->role !== 'admin') {
            abort(403, 'Unauthorized action.');
        }
        $member->delete();
        return redirect()->route('members.index')->with('success', 'Member berhasil dihapus.');
    }

    public function card($id)
    {
        $member = Member::findOrFail($id);

        // QR code as base64 image
        //$qr = base64_encode(QrCode::format('png')->size(120)->generate($member->id));
        $qr = base64_encode(QrCode::format('png')->size(120)->generate((string) $member->id));
        
        return view('members.card', compact('member', 'qr'));
        // Set paper: [0,0,85.6,54] -> 85.6mm x 54mm, landscape
       // return Pdf::loadView('members.card', compact('member', 'qr'))
            //->setPaper([0, 0, 85.6, 54])
        //    ->download('member_card_' . $member->id . '.pdf');
    }

} 
