<?php

namespace App\Http\Controllers;

use App\Models\Instruktur;
use App\Models\PtPurchase;
use Illuminate\Http\Request;

class InstrukturController extends Controller
{
    public function index()
    {
        $instrukturs = \App\Models\Instruktur::orderBy('nama')->paginate(10); // 10 per halaman
        return view('instrukturs.index', compact('instrukturs'));
    }

    public function create()
    {
        return view('instrukturs.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'nama' => 'required|string|max:100',
            'kontak' => 'nullable|string|max:100',
            'alamat' => 'nullable|string|max:255',
        ]);
        Instruktur::create($request->all());
        return redirect()->route('instrukturs.index')->with('success', 'Instruktur berhasil ditambahkan!');
    }

    public function show($id)
    {
        $instruktur = Instruktur::findOrFail($id);
        $riwayat = PtPurchase::where('instruktur_id', $id)
            ->with(['member', 'visitor', 'product'])
            ->orderBy('tanggal', 'desc')
            ->paginate(10); // 10 data per halaman
        return view('instrukturs.show', compact('instruktur', 'riwayat'));
    }

    public function edit($id)
    {
        $instruktur = Instruktur::findOrFail($id);
        return view('instrukturs.edit', compact('instruktur'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'nama' => 'required|string|max:100',
            'kontak' => 'nullable|string|max:100',
            'alamat' => 'nullable|string|max:255',
        ]);
        $instruktur = Instruktur::findOrFail($id);
        $instruktur->update($request->all());
        return redirect()->route('instrukturs.index')->with('success', 'Instruktur berhasil di-update!');
    }

    public function destroy($id)
    {
        if (auth()->user()->role !== 'admin') {
            abort(403, 'Unauthorized action.');
        }
        $instruktur = Instruktur::findOrFail($id);
        $instruktur->delete();
        return redirect()->route('instrukturs.index')->with('success', 'Instruktur berhasil dihapus!');
    }
}